/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.persistence;

import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.services.persistence.AbstractPersistenceService;
import com.smartling.repoconnector.services.persistence.RepositoryPersistenceService;
import com.smartling.repoconnector.services.persistence.dto.RepositoryDTO;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RepositoryPersistenceServiceImpl
extends AbstractPersistenceService
implements RepositoryPersistenceService {
    @Override
    @Transactional(readOnly=true)
    public List<RepositoryDTO> findAll() {
        return this.getDao().search(RepositoryDTO.class, (root, cb) -> cb.createQuery(RepositoryDTO.class).distinct(true));
    }

    @Override
    @Transactional(readOnly=true)
    public List<RepositoryDTO> findAll(RepositoryKey repositoryKey) {
        return this.getDao().search(RepositoryDTO.class, (root, cb) -> cb.createQuery(RepositoryDTO.class).where((Expression)cb.and(new Predicate[]{cb.equal((Expression)root.get("type"), (Object)repositoryKey.getType()), cb.equal((Expression)root.get("host"), (Object)repositoryKey.getHost()), cb.equal((Expression)root.get("path"), (Object)repositoryKey.getPath())})));
    }

    @Override
    @Transactional(readOnly=false)
    public void remove(RepositoryKey repositoryKey) {
        RepositoryDTO repositoryDTO = this.findRepository(repositoryKey);
        if (repositoryDTO != null) {
            this.getDao().delete(repositoryDTO);
        }
    }
}

