/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.persistence;

import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.model.ResourcePersistentData;
import com.smartling.repoconnector.services.persistence.AbstractPersistenceService;
import com.smartling.repoconnector.services.persistence.ResourcePersistenceService;
import com.smartling.repoconnector.services.persistence.dto.LocaleDTO;
import com.smartling.repoconnector.services.persistence.dto.RepositoryDTO;
import com.smartling.repoconnector.services.persistence.dto.ResourceDTO;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Selection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.query.criteria.JpaCriteriaQuery;
import org.hibernate.query.criteria.JpaJoin;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ResourcePersistenceServiceImpl
extends AbstractPersistenceService
implements ResourcePersistenceService {
    @Override
    @Transactional(readOnly=true)
    public ResourcePersistentData findBySmartlingUri(String smartlingUri) {
        return this.findResource(smartlingUri);
    }

    @Override
    @Transactional(readOnly=true)
    public ResourcePersistentData findByRepositoryPath(RepositoryKey repositoryKey, String repositoryPath) {
        return this.findResource(repositoryKey, repositoryPath);
    }

    @Override
    @Transactional(readOnly=true)
    public List<ResourcePersistentData> findAll() {
        return this.getDao().search(ResourceDTO.class, (root, cb) -> cb.createQuery(ResourceDTO.class).distinct(true)).stream().map(ResourcePersistentData.class::cast).toList();
    }

    @Override
    @Transactional(readOnly=true)
    public List<ResourcePersistentData> findAll(RepositoryKey repositoryKey) {
        return this.getDao().search(ResourceDTO.class, (root, cb) -> {
            JpaJoin repositoryJoin = root.join("repository");
            return cb.createQuery(ResourceDTO.class).distinct(true).where((Expression)cb.and(new Predicate[]{cb.equal((Expression)repositoryJoin.get("type"), (Object)repositoryKey.getType()), cb.equal((Expression)repositoryJoin.get("host"), (Object)repositoryKey.getHost()), cb.equal((Expression)repositoryJoin.get("path"), (Object)repositoryKey.getPath()), cb.equal((Expression)repositoryJoin.get("branch"), (Object)repositoryKey.getBranch())}));
        }).stream().map(ResourcePersistentData.class::cast).toList();
    }

    @Override
    @Transactional(readOnly=true)
    public int count(RepositoryKey repositoryKey) {
        return this.getDao().count(ResourceDTO.class, (root, cb) -> {
            JpaCriteriaQuery query = cb.createQuery(Long.class);
            JpaJoin repositoryJoin = root.join("repository");
            return query.select((Selection)cb.count((Expression)root)).where((Expression)cb.and(new Predicate[]{cb.equal((Expression)repositoryJoin.get("type"), (Object)repositoryKey.getType()), cb.equal((Expression)repositoryJoin.get("host"), (Object)repositoryKey.getHost()), cb.equal((Expression)repositoryJoin.get("path"), (Object)repositoryKey.getPath()), cb.equal((Expression)repositoryJoin.get("branch"), (Object)repositoryKey.getBranch())}));
        });
    }

    @Override
    @Transactional(readOnly=false)
    public void remove(RepositoryKey repositoryKey, String repositoryPath) {
        ResourceDTO resource = this.findResource(repositoryKey, repositoryPath);
        if (null != resource) {
            this.deleteLocales(resource);
            this.getDao().delete(resource);
        }
    }

    private void deleteLocales(ResourceDTO resource) {
        for (LocaleDTO locale : resource.getLocales()) {
            this.getDao().delete(locale);
        }
    }

    @Override
    @Transactional
    public void save(ResourcePersistentData resourceData) {
        ResourceDTO resource = this.findResource(resourceData.getRepositoryKey(), resourceData.getRepositoryPath());
        if (null == resource) {
            RepositoryDTO repository = this.findOrCreateRepository(resourceData.getRepositoryKey(), resourceData.getProjectId());
            resource = new ResourceDTO();
            resource.setRepository(repository);
            resource.setRepositoryPath(resourceData.getRepositoryPath());
        }
        resource.setSmartlingUri(resourceData.getSmartlingUri());
        resource.setPathRegex(resourceData.getPathRegex());
        resource.setPathExpression(resourceData.getPathExpression());
        resource.setCommitMessage(resourceData.getCommitMessage());
        resource.setLastModified(resourceData.getLastModified());
        this.updateLocales(resource, resourceData.getLocalesMapping());
        this.getDao().save(resource);
    }

    @Override
    @Transactional
    public void updateLastModified(String smartlingUri, Date lastModified) {
        ResourceDTO resource = this.findResource(smartlingUri);
        if (null != resource) {
            resource.setLastModified(lastModified);
        }
    }

    private ResourceDTO findResource(String smartlingUri) {
        return this.getDao().searchSingle(ResourceDTO.class, (root, cb) -> cb.createQuery(ResourceDTO.class).where((Expression)cb.equal((Expression)root.get("smartlingUri"), (Object)smartlingUri)));
    }

    private ResourceDTO findResource(RepositoryKey repositoryKey, String repositoryPath) {
        return this.getDao().searchSingle(ResourceDTO.class, (root, cb) -> {
            JpaJoin repositoryJoin = root.join("repository");
            return cb.createQuery(ResourceDTO.class).where((Expression)cb.and(new Predicate[]{cb.equal((Expression)root.get("repositoryPath"), (Object)repositoryPath), cb.equal((Expression)repositoryJoin.get("type"), (Object)repositoryKey.getType()), cb.equal((Expression)repositoryJoin.get("host"), (Object)repositoryKey.getHost()), cb.equal((Expression)repositoryJoin.get("path"), (Object)repositoryKey.getPath()), cb.equal((Expression)repositoryJoin.get("branch"), (Object)repositoryKey.getBranch())}));
        });
    }

    private void updateLocales(ResourceDTO resource, Map<String, String> localesMapping) {
        HashSet<String> processed = new HashSet<String>();
        HashSet<LocaleDTO> toDelete = new HashSet<LocaleDTO>();
        for (LocaleDTO localeDTO : resource.getLocales()) {
            String customId = localesMapping.get(localeDTO.getSmartlingId());
            if (null == customId) {
                toDelete.add(localeDTO);
                continue;
            }
            localeDTO.setCustomId(customId);
            processed.add(localeDTO.getSmartlingId());
        }
        resource.getLocales().removeAll(toDelete);
        for (Map.Entry entry : localesMapping.entrySet()) {
            if (processed.contains(entry.getKey())) continue;
            LocaleDTO locale = new LocaleDTO();
            locale.setSmartlingId((String)entry.getKey());
            locale.setCustomId((String)entry.getValue());
            locale.setResource(resource);
            resource.getLocales().add(locale);
        }
    }
}

