/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.persistence;

import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.services.persistence.AbstractPersistenceService;
import com.smartling.repoconnector.services.persistence.RevisionPersistenceService;
import com.smartling.repoconnector.services.persistence.dto.RepositoryDTO;
import com.smartling.repoconnector.services.persistence.dto.RevisionDTO;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.util.Date;
import org.hibernate.query.criteria.JpaJoin;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RevisionPersistenceServiceImpl
extends AbstractPersistenceService
implements RevisionPersistenceService {
    @Override
    @Transactional(readOnly=false)
    public void save(RepositoryKey repositoryKey, String projectId, String revision) {
        RevisionDTO revisionDto = this.findRevision(repositoryKey);
        if (null == revisionDto) {
            RepositoryDTO repository = this.findOrCreateRepository(repositoryKey, projectId);
            revisionDto = new RevisionDTO();
            revisionDto.setRepository(repository);
        }
        revisionDto.setRevision(revision);
        revisionDto.setUpdated(new Date());
        this.getDao().save(revisionDto);
    }

    @Override
    @Transactional(readOnly=true)
    public String lastRevision(RepositoryKey repositoryKey) {
        RevisionDTO revisionDto = this.findRevision(repositoryKey);
        return null == revisionDto ? null : revisionDto.getRevision();
    }

    @Override
    @Transactional(readOnly=true)
    public Date lastUpdated(RepositoryKey repositoryKey) {
        RevisionDTO revisionDto = this.findRevision(repositoryKey);
        return null == revisionDto ? null : revisionDto.getUpdated();
    }

    @Override
    @Transactional(readOnly=false)
    public void remove(RepositoryKey repositoryKey) {
        RevisionDTO revisionDto = this.findRevision(repositoryKey);
        if (revisionDto != null) {
            this.getDao().delete(revisionDto);
        }
    }

    private RevisionDTO findRevision(RepositoryKey repositoryKey) {
        return this.getDao().searchSingle(RevisionDTO.class, (root, cb) -> {
            JpaJoin repositoryJoin = root.join("repository");
            return cb.createQuery(RevisionDTO.class).where((Expression)cb.and(new Predicate[]{cb.equal((Expression)repositoryJoin.get("type"), (Object)repositoryKey.getType()), cb.equal((Expression)repositoryJoin.get("host"), (Object)repositoryKey.getHost()), cb.equal((Expression)repositoryJoin.get("path"), (Object)repositoryKey.getPath()), cb.equal((Expression)repositoryJoin.get("branch"), (Object)repositoryKey.getBranch())}));
        });
    }
}

