/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.persistence.dto;

import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.model.ResourcePersistentData;
import com.smartling.repoconnector.services.persistence.dto.AbstractPersistentDTO;
import com.smartling.repoconnector.services.persistence.dto.LocaleDTO;
import com.smartling.repoconnector.services.persistence.dto.RepositoryDTO;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.Index;

@Entity
@Table(name="resource")
public class ResourceDTO
extends AbstractPersistentDTO
implements ResourcePersistentData {
    private static final long serialVersionUID = 5410337378118291456L;
    private RepositoryDTO repository;
    private String repositoryPath;
    private String smartlingUri;
    private String pathRegex;
    private String pathExpression;
    private String commitMessage;
    private Date lastModified;
    private List<LocaleDTO> locales = new ArrayList<LocaleDTO>();
    private transient Map<String, String> localesMapping;

    @ManyToOne
    @JoinColumn(name="repository_id", nullable=false)
    public RepositoryDTO getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryDTO repository) {
        this.repository = repository;
    }

    @Override
    @Index(name="IDX_REPOSITORY_PATH")
    @Lob
    @Column(name="repositoryPath", nullable=false)
    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public void setRepositoryPath(String repositoryPath) {
        this.repositoryPath = repositoryPath;
    }

    @Override
    @Index(name="IDX_SMARTLING_URI")
    @Column(name="smartlingUri", nullable=false, length=255)
    public String getSmartlingUri() {
        return this.smartlingUri;
    }

    public void setSmartlingUri(String smartlingUri) {
        this.smartlingUri = smartlingUri;
    }

    @Override
    @Column(name="pathRegex", length=255)
    public String getPathRegex() {
        return this.pathRegex;
    }

    public void setPathRegex(String pathRegex) {
        this.pathRegex = pathRegex;
    }

    @Override
    @Column(name="pathExpression", length=255)
    public String getPathExpression() {
        return this.pathExpression;
    }

    public void setPathExpression(String pathExpression) {
        this.pathExpression = pathExpression;
    }

    @Override
    @Column(name="commitMessage", length=255)
    public String getCommitMessage() {
        return this.commitMessage;
    }

    public void setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
    }

    @Override
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lastModified")
    public Date getLastModified() {
        return this.lastModified;
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    @OneToMany(mappedBy="resource", cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true)
    public List<LocaleDTO> getLocales() {
        return this.locales;
    }

    public void setLocales(List<LocaleDTO> locales) {
        this.locales = locales;
    }

    @Override
    @Transient
    public RepositoryKey getRepositoryKey() {
        return new RepositoryKey(this.repository.getType(), this.repository.getProtocol(), this.repository.getHost(), this.repository.getPath(), this.repository.getBranch());
    }

    @Override
    @Transient
    public String getProjectId() {
        return this.repository.getProjectId();
    }

    @Override
    @Transient
    public Map<String, String> getLocalesMapping() {
        if (null == this.localesMapping) {
            this.localesMapping = new HashMap<String, String>();
            for (LocaleDTO locale : this.locales) {
                this.localesMapping.put(locale.getSmartlingId(), locale.getCustomId());
            }
        }
        return this.localesMapping;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceDTO that = (ResourceDTO)o;
        return Objects.equals(this.repository, that.repository) && Objects.equals(this.repositoryPath, that.repositoryPath) && Objects.equals(this.smartlingUri, that.smartlingUri) && Objects.equals(this.pathRegex, that.pathRegex) && Objects.equals(this.pathExpression, that.pathExpression) && Objects.equals(this.commitMessage, that.commitMessage) && Objects.equals(this.lastModified, that.lastModified) && Objects.equals(this.locales, that.locales) && Objects.equals(this.localesMapping, that.localesMapping);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.repository, this.repositoryPath, this.smartlingUri, this.pathRegex, this.pathExpression, this.commitMessage, this.lastModified, this.locales, this.localesMapping);
    }
}

