/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.queue;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.smartling.repoconnector.services.AbstractService;
import com.smartling.repoconnector.services.ServiceException;
import com.smartling.repoconnector.services.event.HealthEvent;
import com.smartling.repoconnector.services.queue.QueueImportSizeGauge;
import com.smartling.repoconnector.services.queue.QueueProvider;
import jakarta.jms.JMSException;
import java.util.HashMap;
import org.apache.activemq.broker.BrokerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ActiveMQProvider
extends AbstractService
implements QueueProvider {
    private static final String HANDLED_CONNECTIONS_HEALTH_NAME = "handledConnections";
    private static final String CONNECTIONS_HEALTH_NAME = "connections";
    private static final String UPTIME_HEALTH_NAME = "uptime";
    private static Logger logger = LoggerFactory.getLogger(ActiveMQProvider.class);
    @Autowired
    @Qualifier(value="jmsBroker")
    private BrokerService broker;
    @Autowired
    private MetricRegistry metricRegistry;
    @Autowired
    private QueueImportSizeGauge queueGauge;

    @Override
    public void start() throws ServiceException {
        try {
            this.metricRegistry.register(MetricRegistry.name((String)this.queueGauge.getQueueName(), (String[])new String[]{"count"}), (Metric)this.queueGauge);
            logger.info("Queue is started");
        }
        catch (JMSException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void stop() throws ServiceException {
        try {
            this.broker.stop();
            this.broker.waitUntilStopped();
            logger.info("Queue is stopped");
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void check() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(UPTIME_HEALTH_NAME, this.broker.getUptime());
        properties.put(CONNECTIONS_HEALTH_NAME, this.broker.getCurrentConnections());
        properties.put(HANDLED_CONNECTIONS_HEALTH_NAME, this.broker.getTotalConnections());
        if (this.broker.isStarted()) {
            this.fireEvent(new HealthEvent((Object)this, this.getClass().getSimpleName(), properties));
        } else {
            this.fireEvent(new HealthEvent((Object)this, this.getClass().getSimpleName(), this.broker.getStartException().getMessage()));
        }
    }
}

