/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.queue;

import com.smartling.repoconnector.model.ImportRequest;
import com.smartling.repoconnector.model.ImportResult;
import com.smartling.repoconnector.services.importer.Importer;
import jakarta.annotation.PostConstruct;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.ObjectMessage;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="importListener")
@Lazy
public class QueueImportDataListener
implements MessageListener {
    private static Logger logger = LoggerFactory.getLogger(QueueImportDataListener.class);
    @Autowired
    private ApplicationContext context;
    private Map<Class<?>, Importer<ImportRequest>> importersByDataClass = new HashMap();

    @PostConstruct
    public void init() {
        Map beans = this.context.getBeansOfType(Importer.class);
        for (Importer importer : beans.values()) {
            Class<?> dataClass = this.getActualGenericArgument(AopProxyUtils.ultimateTargetClass((Object)importer));
            if (dataClass.isInterface() || this.importersByDataClass.containsKey(dataClass)) continue;
            this.importersByDataClass.put(dataClass, importer);
            logger.info("Importer {} is assigned to handle {} data", (Object)importer, (Object)dataClass.getSimpleName());
        }
    }

    public void onMessage(Message message) {
        try {
            ObjectMessage commitMessage = (ObjectMessage)message;
            ImportRequest data = (ImportRequest)commitMessage.getObject();
            MDC.put((String)"projectId", (String)data.getProjectId());
            MDC.put((String)"repositoryKey", (String)data.getRepositoryKey().toString());
            MDC.put((String)"type", (String)data.getImportType().name());
            logger.info("Import event {} has received from queue", (Object)data.getClass().getSimpleName());
            Importer<ImportRequest> importer = this.importersByDataClass.get(data.getClass());
            logger.info("Importer {} is used to handle the event", importer);
            List<ImportResult> result = importer.importData(data);
            logger.info("Import event is processed successfully. Result {}", result);
        }
        catch (Exception e) {
            throw new RuntimeException("Import event processing error", e);
        }
        finally {
            MDC.clear();
        }
    }

    private Class<?> getActualGenericArgument(Class<?> importerClass) {
        Class argument = null;
        block0: for (Class<?> clazz = importerClass; null == argument && null != clazz; clazz = clazz.getSuperclass()) {
            for (Type t : importerClass.getGenericInterfaces()) {
                if (!(t instanceof ParameterizedType) || !Importer.class.equals((Object)((ParameterizedType)t).getRawType())) continue;
                argument = (Class)((ParameterizedType)t).getActualTypeArguments()[0];
                continue block0;
            }
        }
        return argument;
    }
}

