/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.queue;

import com.smartling.repoconnector.model.ImportRequest;
import com.smartling.repoconnector.model.ImportResult;
import com.smartling.repoconnector.model.RepositoryType;
import com.smartling.repoconnector.services.ServiceException;
import com.smartling.repoconnector.services.importer.Importer;
import com.smartling.repoconnector.services.vcs.AbstractRepositoryProtocol;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.stereotype.Component;

@Component(value="proxyImporter")
public class QueueImportDataSender
implements Importer<ImportRequest> {
    @Autowired
    @Qualifier(value="importSender")
    private JmsTemplate sender;
    @Value(value="${queue.messages.quietPeriod}")
    private Long quietPeriod;

    @Override
    public List<ImportResult> importData(final ImportRequest data) throws ServiceException {
        this.sender.send(new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                ObjectMessage message = session.createObjectMessage((Serializable)data);
                String groupId = data.getRepositoryKey().getType() == RepositoryType.SVN ? AbstractRepositoryProtocol.toIdentifierString(data.getRepositoryKey()) : AbstractRepositoryProtocol.toIdentifierStringWithOutBranch(data.getRepositoryKey());
                message.setStringProperty("JMSXGroupID", groupId);
                message.setLongProperty("AMQ_SCHEDULED_DELAY", QueueImportDataSender.this.quietPeriod * 1000L);
                return message;
            }
        });
        return Collections.emptyList();
    }
}

