/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.queue;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSession;
import java.util.Enumeration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueueImportSizeGauge
implements Gauge<Long> {
    @Autowired
    private Queue queue;
    @Autowired
    private QueueConnectionFactory factory;
    @Autowired
    private MetricRegistry metricRegistry;

    public String getQueueName() throws JMSException {
        return this.queue.getQueueName();
    }

    public Long getValue() {
        QueueConnection queueConn = null;
        long numMsgs = 0L;
        try {
            queueConn = this.factory.createQueueConnection();
            numMsgs = 0L;
            QueueSession queueSession = queueConn.createQueueSession(false, 1);
            QueueBrowser queueBrowser = queueSession.createBrowser(this.queue);
            queueConn.start();
            Enumeration e = queueBrowser.getEnumeration();
            while (e.hasMoreElements()) {
                e.nextElement();
                ++numMsgs;
            }
        }
        catch (JMSException e) {
            throw new RuntimeException();
        }
        finally {
            if (null != queueConn) {
                try {
                    queueConn.close();
                }
                catch (JMSException jMSException) {}
            }
        }
        return numMsgs;
    }
}

