/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.scheduler;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.services.branch.BranchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class DeletedBranchesChecker
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(DeletedBranchesChecker.class);
    @Autowired
    private BranchService branchService;
    @Autowired
    private MetricRegistry metricRegistry;
    private RepositoryKey repositoryKey;

    public DeletedBranchesChecker(RepositoryKey repositoryKey) {
        this.repositoryKey = repositoryKey;
    }

    @Override
    public void run() {
        logger.info("Clean branches task is starting...");
        Timer.Context timerContext = this.metricRegistry.timer(MetricRegistry.name((String)this.getClass().getSimpleName(), (String[])new String[]{"processingTime"})).time();
        try {
            this.branchService.cleanDeletedBranches(this.repositoryKey);
        }
        finally {
            timerContext.stop();
        }
        logger.info("Clean branches task is completed");
    }
}

