/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.scheduler;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.smartling.repoconnector.model.ImportRequest;
import com.smartling.repoconnector.model.ImportResult;
import com.smartling.repoconnector.model.PollImportRequest;
import com.smartling.repoconnector.model.ProjectData;
import com.smartling.repoconnector.model.PushImportRequest;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.services.ServiceException;
import com.smartling.repoconnector.services.importer.AbstractImporter;
import com.smartling.repoconnector.services.importer.Importer;
import com.smartling.repoconnector.services.persistence.RevisionPersistenceService;
import com.smartling.repoconnector.services.vcs.AbstractRepositoryProtocol;
import com.smartling.repoconnector.services.vcs.Branch;
import com.smartling.repoconnector.services.vcs.RepositoryConnector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class RepositoryPollingImporterImpl
extends AbstractImporter
implements Importer<PollImportRequest> {
    private static Logger logger = LoggerFactory.getLogger(RepositoryPollingImporterImpl.class);
    @Autowired
    private RevisionPersistenceService persistenceService;
    @Autowired
    @Qualifier(value="proxyImporter")
    private Importer<ImportRequest> importer;

    @Override
    public List<ImportResult> importData(PollImportRequest request) throws ServiceException {
        RepositoryKey repositoryKey = request.getRepositoryKey();
        logger.info("Check repository task is starting...");
        Timer.Context timerContext = this.getMetricRegistry().timer(this.getTimerName(request.getRepositoryKey())).time();
        try {
            List<Branch> branches;
            try (RepositoryConnector repository = this.getRepositoryConnector(repositoryKey);){
                branches = repository.getBranches();
            }
            this.registerBranchCountStats(repositoryKey, branches.size());
            ProjectData projectData = this.getProjectData(repositoryKey);
            ArrayList<ImportResult> result = new ArrayList<ImportResult>(branches.size());
            for (Branch branch : branches) {
                RepositoryKey branchRepositoryKey = repositoryKey.cloneForBranch(branch.getName());
                RepositoryConnector branchRepository = this.getRepositoryConnector(branchRepositoryKey);
                try {
                    if (!projectData.isBranchSuitable(branch.getName()) || branchRepository.isBranchOutdated(branch.getName(), projectData) || branch.getRevision().equals(this.persistenceService.lastRevision(branchRepositoryKey))) continue;
                    logger.info("Scheduler creates an import request for {} branch and {} revision", (Object)branch.getName(), (Object)branch.getRevision());
                    result.addAll(this.importer.importData(new PushImportRequest(branchRepositoryKey, request.getProjectId(), branch.getRevision())));
                }
                finally {
                    if (branchRepository == null) continue;
                    branchRepository.close();
                }
            }
            ArrayList<ImportResult> arrayList = result;
            return arrayList;
        }
        catch (ServiceException | IOException e) {
            throw new ServiceException(String.format("Error during repository polling request \"%s\"", request), e);
        }
        finally {
            logger.info("Check repository task is finished");
            timerContext.stop();
        }
    }

    private void registerBranchCountStats(RepositoryKey repositoryKey, int branchCount) {
        Histogram branchesCount = this.getMetricRegistry().histogram(MetricRegistry.name((String)this.getClass().getSimpleName(), (String[])new String[]{AbstractRepositoryProtocol.toIdentifierString(repositoryKey), "branches", "count"}));
        branchesCount.update(branchCount);
    }

    private String getTimerName(RepositoryKey repositoryKey) {
        return MetricRegistry.name((String)this.getClass().getSimpleName(), (String[])new String[]{AbstractRepositoryProtocol.toIdentifierString(repositoryKey), "processingTime"});
    }
}

