/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.scheduler;

import com.smartling.repoconnector.model.ImportRequest;
import com.smartling.repoconnector.model.PollImportRequest;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.services.ServiceException;
import com.smartling.repoconnector.services.importer.Importer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class RepositoryPollingTask
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(RepositoryPollingTask.class);
    private String projectId;
    private RepositoryKey repositoryKey;
    @Autowired
    @Qualifier(value="proxyImporter")
    private Importer<ImportRequest> importer;
    @Value(value="${scheduler.quietPeriod}")
    private Long quietPeriod;
    private Long lastExecuted;

    public RepositoryPollingTask(String projectId, RepositoryKey repositoryKey) {
        this.projectId = projectId;
        this.repositoryKey = repositoryKey;
    }

    @Override
    public void run() {
        if (null == this.lastExecuted || System.currentTimeMillis() > this.lastExecuted + this.quietPeriod * 1000L) {
            try {
                this.importer.importData(new PollImportRequest(this.repositoryKey, this.projectId));
            }
            catch (ServiceException e) {
                logger.error("Sending polling message failed for projectId={} and repositoryKey={}", new Object[]{this.projectId, this.repositoryKey, e});
            }
            this.lastExecuted = System.currentTimeMillis();
        } else {
            try {
                Thread.sleep(this.quietPeriod * 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

