/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.scheduler;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.smartling.repoconnector.model.ImportRequest;
import com.smartling.repoconnector.model.ImportType;
import com.smartling.repoconnector.model.ResourcePersistentData;
import com.smartling.repoconnector.model.TranslationImportRequest;
import com.smartling.repoconnector.services.ConfigurationException;
import com.smartling.repoconnector.services.ServiceException;
import com.smartling.repoconnector.services.importer.Importer;
import com.smartling.repoconnector.services.integration.uploader.SmartlingApiFacade;
import com.smartling.repoconnector.services.persistence.ResourcePersistenceService;
import com.smartling.repoconnector.services.utils.ResourceUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class TranslationStatusChecker {
    private static Logger logger = LoggerFactory.getLogger(TranslationStatusChecker.class);
    @Autowired
    private ResourcePersistenceService persistenceService;
    @Autowired
    private SmartlingApiFacade smartlingConnector;
    @Autowired
    @Qualifier(value="proxyImporter")
    private Importer<ImportRequest> importer;
    @Autowired
    private MetricRegistry metricRegistry;
    @Value(value="${scheduler.quietPeriod}")
    private Long quietPeriod;
    private Long lastExecuted;

    @Scheduled(cron="${scheduler.checkTranslation.cron}")
    public void checkStatus() throws ServiceException, InterruptedException {
        if (this.isTimeForCheck()) {
            this.activateCheckTranslationTask();
        } else {
            this.sleepForQuietPeriod();
        }
    }

    private boolean isTimeForCheck() {
        return null == this.lastExecuted || System.currentTimeMillis() > this.lastExecuted + this.quietPeriod * 1000L;
    }

    private void sleepForQuietPeriod() throws InterruptedException {
        Thread.sleep(this.quietPeriod * 1000L);
    }

    private void activateCheckTranslationTask() {
        logger.info("Check translations task is starting...");
        Timer.Context timerContext = this.metricRegistry.timer(MetricRegistry.name((String)this.getClass().getSimpleName(), (String[])new String[]{"processingTime"})).time();
        try {
            this.importResources();
        }
        finally {
            timerContext.stop();
            this.lastExecuted = System.currentTimeMillis();
            MDC.clear();
        }
        logger.info("Check translations task is completed");
    }

    private void importResources() {
        List<ResourcePersistentData> resources = this.persistenceService.findAll();
        Histogram resourcesCount = this.metricRegistry.histogram(MetricRegistry.name((String)this.getClass().getSimpleName(), (String[])new String[]{"resources", "count"}));
        resourcesCount.update(resources.size());
        Collection<TranslationImportRequest> translationImportRequestData = this.mapToTranslationRequest(this.filterResourcesThatSupportDownload(resources));
        this.importResourceForLocale(translationImportRequestData);
    }

    private Collection<ResourcePersistentData> filterResourcesThatSupportDownload(List<ResourcePersistentData> resources) {
        ArrayList<ResourcePersistentData> result = new ArrayList<ResourcePersistentData>();
        for (ResourcePersistentData resource : resources) {
            MDC.put((String)"projectId", (String)resource.getProjectId());
            MDC.put((String)"repositoryKey", (String)resource.getRepositoryKey().toString());
            MDC.put((String)"type", (String)ImportType.SMARTLING2VCS.name());
            if (!ResourceUtils.isSupportsDownload(resource)) continue;
            result.add(resource);
        }
        return result;
    }

    private Collection<TranslationImportRequest> mapToTranslationRequest(Collection<ResourcePersistentData> resources) {
        ArrayList<TranslationImportRequest> result = new ArrayList<TranslationImportRequest>(resources.size());
        for (ResourcePersistentData resourcePersistentData : resources) {
            try {
                List<String> locales = this.smartlingConnector.getUpdatedLocales(resourcePersistentData);
                result.add(new TranslationImportRequest(resourcePersistentData, locales, false));
            }
            catch (ConfigurationException | ServiceException e) {
                logger.error("Could not getUpdatedLocales [uri='{}']", (Object)resourcePersistentData.getSmartlingUri(), (Object)e);
            }
        }
        return result;
    }

    private void importResourceForLocale(Collection<TranslationImportRequest> data) {
        logger.info("Scheduler creates an import request for {}", this.extractSmartlingUris(data));
        try {
            for (TranslationImportRequest request : data) {
                this.importer.importData(request);
            }
        }
        catch (ServiceException e) {
            logger.error("Could not import data {}", data, (Object)e);
        }
    }

    private Collection<String> extractSmartlingUris(Collection<TranslationImportRequest> data) {
        if (data == null) {
            return Collections.emptyList();
        }
        ArrayList<String> smartlingUris = new ArrayList<String>(data.size());
        for (TranslationImportRequest datum : data) {
            smartlingUris.add(datum.getSmartlingUri());
        }
        return smartlingUris;
    }
}

