/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.utils;

import com.smartling.repoconnector.services.ServiceException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FileOperations {
    private static Logger logger = LoggerFactory.getLogger(FileOperations.class);

    public File createFileBuffer(InputStream content) throws ServiceException {
        File contentFile = this.createTempFile("smtl-download", ".tmp");
        try {
            contentFile.deleteOnExit();
            IOUtils.copy(content, (OutputStream)new FileOutputStream(contentFile));
            return contentFile;
        }
        catch (IOException e) {
            contentFile.delete();
            throw new ServiceException("Can't bufferize content to temp file", e);
        }
    }

    public void storeBufferedContent(File localRepoFile, File bufferedContent) throws ServiceException {
        try {
            FileUtils.copyFile(bufferedContent, localRepoFile);
        }
        catch (Exception e) {
            logger.error("Error writing content to fileUri=\"{}\"", (Object)localRepoFile.getPath(), (Object)e);
            throw new ServiceException(e);
        }
        finally {
            if (!bufferedContent.delete()) {
                logger.warn("Couldn't delete temporary file with buffered content. fileName={}", (Object)bufferedContent.getAbsolutePath());
            }
        }
    }

    public boolean contentDiffers(File localRepoFile, File bufferedContent) throws ServiceException {
        try {
            return this.contentNotEquals(localRepoFile, bufferedContent);
        }
        catch (IOException e) {
            throw new ServiceException("Couldn't check differences between repo file and buffered content", e);
        }
    }

    private boolean contentNotEquals(File localRepoFile, File bufferedContent) throws IOException {
        return !FileUtils.contentEquals(localRepoFile, bufferedContent);
    }

    private File createTempFile(String prefix, String suffix) throws ServiceException {
        try {
            return File.createTempFile(prefix, suffix);
        }
        catch (IOException e) {
            throw new ServiceException("Can't create buffer for content to temp file", e);
        }
    }
}

