/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.utils;

public class RepoFileUtils {
    public static final int DEFAULT_SHORTENER_THRESHOLD = 4;
    public static final String SHORTENER_BACKSLASH_REGEX = "\\\\";
    public static final String SHORTENER_SLASH_REGEX = "/";
    public static final String SHORTENER_BACKSLASH = "\\";
    public static final String SHORTENER_SLASH = "/";
    public static final String SHORTENER_ELLIPSE = "...";
    private static final String REGEXP_INVALID_FILENAME_CHARS = "(\\.|%|&|/|\\\\|\\:|\\*|\\?|\"|<|>|\\||\\s)+";
    private static final String WHITESPACES_EXPRESSION = "\\s+";
    private static final String UNDERSCORES_CHARACTER = "_";
    private static final String SPACE_CHARACTER = " ";

    public static String pathShortener(String path, int threshold) {
        String regex = SHORTENER_BACKSLASH_REGEX;
        String sep = SHORTENER_BACKSLASH;
        if (path.indexOf("/") > 0) {
            regex = "/";
            sep = "/";
        }
        String[] pathtemp = path.split(regex);
        int elem = 0;
        String[] newtemp = new String[pathtemp.length];
        int j = 0;
        for (int i = 0; i < pathtemp.length; ++i) {
            if (pathtemp[i].equals("")) continue;
            newtemp[j++] = pathtemp[i];
            ++elem;
        }
        pathtemp = newtemp;
        if (elem > threshold) {
            StringBuilder sb = new StringBuilder();
            int index = 0;
            int pos2dots = path.indexOf(":");
            if (pos2dots > 0) {
                sb.append(path.substring(0, pos2dots + 2));
                ++index;
                if (path.indexOf(":/") > 0 && pathtemp[0].length() > 2) {
                    sb.append("/");
                }
            } else {
                boolean isUNC = path.substring(0, 2).equals(SHORTENER_BACKSLASH_REGEX);
                if (isUNC) {
                    sb.append(SHORTENER_BACKSLASH).append(SHORTENER_BACKSLASH);
                }
            }
            while (index <= threshold) {
                sb.append(pathtemp[index]).append(sep);
                ++index;
            }
            if (index == elem - 1) {
                sb.append(pathtemp[elem - 1]);
            } else {
                sb.append(SHORTENER_ELLIPSE).append(sep).append(pathtemp[elem - 1]);
            }
            return sb.toString();
        }
        return path;
    }

    public static String pathLengthShortener(String path, int limit) {
        int i;
        if (path.length() <= limit) {
            return path;
        }
        char[] shortPathArray = new char[limit];
        char[] pathArray = path.toCharArray();
        char[] ellipseArray = SHORTENER_ELLIPSE.toCharArray();
        int pathindex = pathArray.length - 1;
        int shortpathindex = limit - 1;
        for (i = 0; i < limit && pathArray[pathindex - i] != '/' && pathArray[pathindex - i] != '\\'; ++i) {
            shortPathArray[shortpathindex - i] = pathArray[pathindex - i];
        }
        int free = limit - i;
        if (free < SHORTENER_ELLIPSE.length()) {
            for (int j = 0; j < ellipseArray.length; ++j) {
                shortPathArray[j] = ellipseArray[j];
            }
        } else {
            int j = 0;
            while (j + ellipseArray.length < free) {
                shortPathArray[j] = pathArray[j];
                ++j;
            }
            int k = 0;
            while (j + k < free) {
                shortPathArray[j + k] = ellipseArray[k];
                ++k;
            }
        }
        return new String(shortPathArray);
    }

    public static String shortenerSmartlingUri(String prefix, String resourcePath) {
        String keyPath = "/" + prefix + "/";
        Object uri = null;
        if (keyPath.length() + resourcePath.length() > 255) {
            String hash = Integer.toString(resourcePath.hashCode(), 16);
            uri = keyPath + RepoFileUtils.pathLengthShortener(resourcePath, 255 - keyPath.length() - hash.length() - 3);
            uri = ((String)uri).replace(SHORTENER_ELLIPSE, SHORTENER_ELLIPSE + hash + SHORTENER_ELLIPSE);
        } else {
            uri = keyPath + resourcePath;
        }
        return uri;
    }

    public static String removeLeadSlash(String path) {
        String result = path;
        if (path.startsWith("/") || path.startsWith(SHORTENER_BACKSLASH)) {
            result = path.substring(1);
        }
        return result;
    }

    public static String collapseDoubleSlashes(String path) {
        return path.replaceAll("//", "/");
    }

    public static String makeValidFileName(String str) {
        String fileName = "";
        if (null != str && 0 < str.length()) {
            fileName = str.replaceAll(REGEXP_INVALID_FILENAME_CHARS, SPACE_CHARACTER);
            fileName = fileName.replaceAll(WHITESPACES_EXPRESSION, UNDERSCORES_CHARACTER);
        }
        return fileName.trim();
    }
}

