/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.vcs;

import com.smartling.repoconnector.model.AuthenticationData;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.services.AbstractService;
import com.smartling.repoconnector.services.ServiceException;
import com.smartling.repoconnector.services.event.RepositoryHealthEvent;
import com.smartling.repoconnector.services.vcs.AbstractRepositoryProtocol;
import com.smartling.repoconnector.services.vcs.RepositoryConnector;
import jakarta.annotation.PostConstruct;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractRepositoryConnector
extends AbstractService
implements RepositoryConnector {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRepositoryConnector.class);
    private static final String CLONE_DIRECTORY = "repository-data";
    private RepositoryKey key;
    private AuthenticationData data;
    private AbstractRepositoryProtocol protocol;
    @Value(value="${clone_directory}")
    private String cloneDirectory;

    public AbstractRepositoryConnector(RepositoryKey key, AuthenticationData data, AbstractRepositoryProtocol protocol) {
        this.key = key;
        this.data = data;
        this.protocol = protocol;
    }

    @PostConstruct
    public void init() {
        if (StringUtils.isBlank(this.cloneDirectory)) {
            this.cloneDirectory = FilenameUtils.concat(this.getConfigurationDirectory(), CLONE_DIRECTORY);
        }
        this.protocol.onOpenConnector(this.key, this.data);
        logger.debug("RepositoryConnector type {} auth {} is initialized", (Object)this.getClass().getSimpleName(), (Object)this.data.getAuthenticationType());
    }

    @Override
    public void close() {
        this.protocol.onCloseConnector(this.key, this.data);
        logger.debug("Repository is closed");
    }

    protected RepositoryKey getKey() {
        return this.key;
    }

    protected AuthenticationData getData() {
        return this.data;
    }

    protected <T extends AbstractRepositoryProtocol> T getProtocol() {
        return (T)this.protocol;
    }

    protected String getCloneDirectory() {
        return this.cloneDirectory;
    }

    @Override
    public String localPath() {
        return FilenameUtils.concat(this.getCloneDirectory(), AbstractRepositoryProtocol.toIdentifierString(this.getKey()));
    }

    protected String getRepositoryUrl() {
        return this.protocol.getRepositoryUrl(this.key, this.data);
    }

    protected void rethrowException(Exception e) throws ServiceException {
        this.handleException(e);
        if (e instanceof ServiceException) {
            throw (ServiceException)e;
        }
        throw new ServiceException(e);
    }

    protected void handleException(Exception e) {
        logger.error("Repository error", (Throwable)e);
        this.fireEvent(new RepositoryHealthEvent((Object)this, this.key, e.getMessage()));
    }
}

