/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.vcs;

import com.google.code.regexp.Matcher;
import com.google.code.regexp.Pattern;
import com.smartling.repoconnector.model.AuthenticationData;
import com.smartling.repoconnector.model.ProtocolType;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.model.RepositoryType;
import com.smartling.repoconnector.services.utils.RepoFileUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public abstract class AbstractRepositoryProtocol {
    protected static final String PATH_GROUP = "path";
    protected static final String HOST_GROUP = "host";
    protected static final String PROTOCOL_GROUP = "protocol";
    protected static final String UNDERSCORE_SEPARATOR = "_";
    protected static final String COLON_SEPARATOR = ":";
    protected static final String AT_SEPARATOR = "@";
    protected static final String DOT_SEPARATOR = ".";
    protected static final String SLASH_SEPARATOR = "/";
    protected static final String PROTOCOL_SEPARATOR = "://";
    protected static final Pattern HTTP_URL_PATTERN = Pattern.compile((String)"^(?<protocol>\\w*)://(?<host>[^/]*)/(?<path>.*)$");

    public RepositoryKey getKeyFromUrl(RepositoryType type, String repositoryUrl, String branch) {
        Triple<String, String, String> keyData = this.getKeyByPattern(HTTP_URL_PATTERN, repositoryUrl);
        return null == keyData ? null : new RepositoryKey(type, ProtocolType.getType(keyData.getLeft()), keyData.getMiddle(), keyData.getRight(), branch);
    }

    public abstract boolean isApplicable(RepositoryKey var1, AuthenticationData var2);

    public String getRepositoryUrl(RepositoryKey key, AuthenticationData authData) {
        return key.getProtocol().getName() + PROTOCOL_SEPARATOR + key.getHost() + SLASH_SEPARATOR + key.getPath();
    }

    public void onOpenConnector(RepositoryKey key, AuthenticationData data) {
    }

    public void onCloseConnector(RepositoryKey key, AuthenticationData data) {
    }

    public static String toIdentifierString(RepositoryKey key) {
        return RepoFileUtils.makeValidFileName(key.getType() + UNDERSCORE_SEPARATOR + key.getHost() + UNDERSCORE_SEPARATOR + key.getPath() + UNDERSCORE_SEPARATOR + key.getBranch());
    }

    public static String toIdentifierStringWithOutBranch(RepositoryKey key) {
        return RepoFileUtils.makeValidFileName(key.getType() + UNDERSCORE_SEPARATOR + key.getHost() + UNDERSCORE_SEPARATOR + key.getPath());
    }

    protected Triple<String, String, String> getKeyByPattern(Pattern urlPattern, String repositoryUrl) {
        ImmutableTriple<String, String, String> key = null;
        Matcher matcher = urlPattern.matcher((CharSequence)repositoryUrl);
        if (matcher.matches()) {
            String protocol = null;
            try {
                protocol = matcher.group(PROTOCOL_GROUP);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            key = new ImmutableTriple<String, String, String>(protocol, matcher.group(HOST_GROUP), matcher.group(PATH_GROUP));
        }
        return key;
    }
}

