/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.vcs;

import com.smartling.repoconnector.model.AuthenticationData;
import com.smartling.repoconnector.model.ImportType;
import com.smartling.repoconnector.model.ProjectData;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.model.RepositoryType;
import com.smartling.repoconnector.services.AbstractService;
import com.smartling.repoconnector.services.ConfigurationException;
import com.smartling.repoconnector.services.CredentialsInvalidException;
import com.smartling.repoconnector.services.event.RepositoryHealthEvent;
import com.smartling.repoconnector.services.exception.SmartlingRestApiException;
import com.smartling.repoconnector.services.integration.uploader.SmartlingApiFacade;
import com.smartling.repoconnector.services.scheduler.DeletedBranchesChecker;
import com.smartling.repoconnector.services.scheduler.RepositoryPollingTask;
import com.smartling.repoconnector.services.vcs.AbstractRepositoryProtocol;
import com.smartling.repoconnector.services.vcs.RepositoryConnector;
import com.smartling.repoconnector.services.vcs.RepositoryFactory;
import com.smartling.repoconnector.services.vcs.data.AuthenticationConfig;
import com.smartling.repoconnector.services.vcs.data.ProjectAuthenticationDataProvider;
import com.smartling.repoconnector.services.vcs.data.RepositoryDataProvider;
import com.typesafe.config.Config;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;

@Service
public class RepositoryFactoryImpl
extends AbstractService
implements RepositoryFactory {
    private static final String PROTOCOL_BEAN_NAME = "protocolBeanName";
    private static final String CONNECTOR_BEAN_NAME = "connectorBeanName";
    private static final Logger logger = LoggerFactory.getLogger(RepositoryFactoryImpl.class);
    @Autowired
    private Config configuration;
    private final List<Pair<String, String>> beans = new ArrayList<Pair<String, String>>();

    @PostConstruct
    public void init() {
        logger.info("Repository factory configuration are reading...");
        List repositoriesConfig = this.configuration.getConfigList("vcs.protocols");
        for (Config repositoryConfig : repositoriesConfig) {
            this.beans.add(new ImmutablePair<String, String>(repositoryConfig.getString(PROTOCOL_BEAN_NAME), repositoryConfig.getString(CONNECTOR_BEAN_NAME)));
        }
        logger.info("Repository factory configuration are read successfully. There are {} specific connectors", (Object)this.beans.size());
    }

    @Override
    public RepositoryConnector getConnector(RepositoryKey repositoryKey) {
        Pair<String, String> repositoryBeans = null;
        AbstractRepositoryProtocol repositoryProtocol = null;
        AuthenticationData repositoryData = this.getRepositoryDataProvider().getRepositoryData(repositoryKey);
        for (Pair<String, String> container : this.beans) {
            AbstractRepositoryProtocol protocol = (AbstractRepositoryProtocol)this.getBean(container.getKey(), new Object[0]);
            if (!protocol.isApplicable(repositoryKey, repositoryData)) continue;
            repositoryBeans = container;
            repositoryProtocol = protocol;
            break;
        }
        if (repositoryBeans == null) {
            this.fireEvent(new RepositoryHealthEvent((Object)this, repositoryKey, "Can't find connector from registered beans [%s] applicable to configured repository\", beans"));
            throw new ConfigurationException(String.format("Can't find connector from registered beans [%s] applicable to configured repository", this.beans));
        }
        RepositoryConnector connector = (RepositoryConnector)this.getBean((String)repositoryBeans.getValue(), repositoryKey, repositoryData, repositoryProtocol);
        logger.trace("Factory returns {} protocol named {}", (Object)repositoryBeans.getValue(), (Object)repositoryBeans.getKey());
        return connector;
    }

    @Override
    public RepositoryKey getKeyFromUrl(RepositoryType type, String repositoryUrl, String branch) {
        Pair<String, String> container;
        AbstractRepositoryProtocol protocol;
        RepositoryKey repositoryKey = null;
        Iterator<Pair<String, String>> iterator = this.beans.iterator();
        while (iterator.hasNext() && null == (repositoryKey = (protocol = (AbstractRepositoryProtocol)this.getBean((container = iterator.next()).getKey(), new Object[0])).getKeyFromUrl(type, repositoryUrl, branch))) {
        }
        return repositoryKey;
    }

    @Override
    public ProjectData getProjectData(RepositoryKey repositoryKey) {
        return this.getRepositoryDataProvider().getProjectData(repositoryKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateAllRepositories() {
        RepositoryDataProvider repositoryDataProvider = this.getRepositoryDataProvider();
        HashMap<AuthenticationConfig, String> authCheckResults = new HashMap<AuthenticationConfig, String>();
        for (RepositoryKey repositoryKey : repositoryDataProvider.getRepositoryKeys()) {
            MDC.put((String)"repositoryKey", (String)repositoryKey.toString());
            MDC.put((String)"projectId", (String)repositoryDataProvider.getProjectData(repositoryKey).getProjectId());
            try {
                RepositoryConnector connector = this.getConnector(repositoryKey);
                try {
                    this.checkCreds(connector, repositoryKey, authCheckResults);
                }
                finally {
                    if (connector == null) continue;
                    connector.close();
                }
            }
            catch (Exception e) {
                logger.error("Error while validating repositories", (Throwable)e);
            }
            finally {
                MDC.remove((String)"repositoryKey");
                MDC.remove((String)"projectId");
            }
        }
    }

    private void checkCreds(RepositoryConnector connector, RepositoryKey repositoryKey, Map<AuthenticationConfig, String> authCheckResults) {
        AuthenticationConfig authData = this.getBean(ProjectAuthenticationDataProvider.class, new Object[0]).getProjectAuthenticationData(repositoryKey);
        try {
            String error;
            if (!authCheckResults.containsKey(authData)) {
                this.getBean(SmartlingApiFacade.class, new Object[0]).checkProjectAccess(authData);
                authCheckResults.put(authData, null);
            }
            if ((error = authCheckResults.get(authData)) == null && connector.checkAccess()) {
                this.fireEvent(new RepositoryHealthEvent((Object)this, repositoryKey));
            } else {
                this.fireEvent(new RepositoryHealthEvent((Object)this, repositoryKey, error));
            }
        }
        catch (CredentialsInvalidException | SmartlingRestApiException e) {
            logger.error("Error during check of project's access", (Throwable)e);
            authCheckResults.put(authData, e.getMessage());
            this.fireEvent(new RepositoryHealthEvent((Object)this, repositoryKey, e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleAllRepositories() {
        RepositoryDataProvider repositoryDataProvider = this.getRepositoryDataProvider();
        TaskScheduler scheduler = (TaskScheduler)this.getBean("scheduler", new Object[0]);
        for (RepositoryKey repositoryKey : repositoryDataProvider.getRepositoryKeys()) {
            ProjectData projectData = repositoryDataProvider.getProjectData(repositoryKey);
            String poolingSchedule = projectData.getPollingSchedule();
            if (!StringUtils.isNoneBlank(poolingSchedule)) continue;
            try {
                MDC.put((String)"repositoryKey", (String)repositoryKey.toString());
                MDC.put((String)"projectId", (String)projectData.getProjectId());
                MDC.put((String)"type", (String)ImportType.VCS2SMARTLING.name());
                Runnable task = this.getBean(RepositoryPollingTask.class, projectData.getProjectId(), repositoryKey);
                scheduler.schedule(task, (Trigger)new CronTrigger(poolingSchedule));
                logger.info("Pooling task is scheduled with cron expression {}", (Object)poolingSchedule);
            }
            finally {
                MDC.clear();
            }
        }
    }

    @Override
    public void scheduleCleaningBranches() {
        RepositoryDataProvider repositoryDataProvider = this.getRepositoryDataProvider();
        TaskScheduler scheduler = (TaskScheduler)this.getBean("scheduler", new Object[0]);
        for (RepositoryKey repositoryKey : repositoryDataProvider.getRepositoryKeys()) {
            Runnable task = this.getBean(DeletedBranchesChecker.class, repositoryKey);
            ProjectData projectData = repositoryDataProvider.getProjectData(repositoryKey);
            String cleanBranchesSchedule = projectData.getCleanBranchesSchedule();
            if (!StringUtils.isNoneBlank(cleanBranchesSchedule)) continue;
            scheduler.schedule(task, (Trigger)new CronTrigger(cleanBranchesSchedule));
        }
    }

    private RepositoryDataProvider getRepositoryDataProvider() {
        return this.getBean(RepositoryDataProvider.class, new Object[0]);
    }
}

