/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.vcs.data;

import com.smartling.api.files.v2.pto.RetrievalType;
import com.smartling.repoconnector.model.AuthenticationData;
import com.smartling.repoconnector.model.ProjectData;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.model.RepositoryType;
import com.smartling.repoconnector.model.RetrievalTriggerType;
import com.smartling.repoconnector.services.ConfigurationException;
import com.smartling.repoconnector.services.ServiceException;
import com.smartling.repoconnector.services.event.PushRequestVoteEvent;
import com.smartling.repoconnector.services.vcs.RepositoryFactory;
import com.smartling.repoconnector.services.vcs.data.AuthenticationConfig;
import com.smartling.repoconnector.services.vcs.data.RepositoryDataProvider;
import com.smartling.repoconnector.services.vcs.data.authentication.AbstractAuthenticationBuilder;
import com.smartling.repoconnector.services.vcs.data.authentication.HTTPAuthenticationBuilder;
import com.smartling.repoconnector.services.vcs.data.authentication.OAuthAccessTokenAuthenticationBuilder;
import com.smartling.repoconnector.services.vcs.data.authentication.PersonalTokenAuthenticationBuilder;
import com.smartling.repoconnector.services.vcs.data.authentication.SSHKeyAuthenticationBuilder;
import com.smartling.repoconnector.services.vcs.data.authentication.UserPasswordAuthenticationBuilder;
import com.typesafe.config.Config;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
public class ConfigRepositoryDataProviderImpl
implements RepositoryDataProvider,
ApplicationListener<PushRequestVoteEvent> {
    private static final int MAX_ALIAS_LENGTH = 240;
    private static final String ALIAS_CONFIG_PATH = "alias";
    private static final String REPOSITORY_URL_CONFIG_PATH = "url";
    private static final String REPOSITORY_TYPE_CONFIG_PATH = "type";
    private static final String PROJECT_CONFIG_PATH = "smartlingProject";
    private static final String PROJECT_ID_CONFIG_PATH = "projectId";
    private static final String PROJECT_USER_IDENTIFIER_CONFIG_PATH = "userIdentifier";
    private static final String PROJECT_TOKEN_SECRET_CONFIG_PATH = "tokenSecret";
    private static final String RESOURCES_CONFIG_CONFIG_PATH = "resourcesConfig";
    private static final String SERVER_RESOURCES_CONFIG_CONFIG_PATH = "serverResourcesConfig";
    private static final String BRANCHES_CONFIG_PATH = "branches";
    private static final String POLLING_SCHEDULE_CONFIG_PATH = "pollingSchedule";
    private static final String CLEAN_BRANCHES_SCHEDULE = "purgeBranchesSchedule";
    private static final String LAYOUT_TRUNK_FOLDER_CONFIG_PATH = "layout.trunkFolder";
    private static final String LAYOUT_BRANCHES_FOLDER_CONFIG_PATH = "layout.branchesFolder";
    private static final String NAMESPACE_CONFIG_PATH = "namespace";
    private static final String RETRIEVAL_TRIGGER_TYPE_CONFIG_PATH = "downloadTranslations.trigger";
    private static final String RETRIEVAL_TYPE_CONFIG_PATH = "downloadTranslations.retrievalType";
    private static final String INCLUDE_ORIGINAL_STRINGS_CONFIG_PATH = "downloadTranslations.includeOriginalStrings";
    private static final String OUTDATED_BRANCHES_DAYS = "outdatedBranchesDays";
    private static final String POST_CHECKOUT_HOOK = "postCheckoutHook";
    private static final String PRE_COMMIT_HOOK = "preCommitHook";
    private static final String CLONE_SINGLE_BRANCH_CONFIG_PATH = "cloneSingleBranch";
    private static Logger logger = LoggerFactory.getLogger(ConfigRepositoryDataProviderImpl.class);
    private Map<RepositoryKey, Triple<AuthenticationData, ProjectData, AuthenticationConfig>> repositoryData = new HashMap<RepositoryKey, Triple<AuthenticationData, ProjectData, AuthenticationConfig>>();
    private final List<AbstractAuthenticationBuilder> authenticationBuilders = new ArrayList<AbstractAuthenticationBuilder>();
    @Autowired
    private RepositoryFactory repositoryFactory;
    @Autowired
    private Config configuration;

    @PostConstruct
    public void init() throws ServiceException {
        this.authenticationBuilders.add(new OAuthAccessTokenAuthenticationBuilder());
        this.authenticationBuilders.add(new PersonalTokenAuthenticationBuilder());
        this.authenticationBuilders.add(new UserPasswordAuthenticationBuilder());
        this.authenticationBuilders.add(new HTTPAuthenticationBuilder());
        this.authenticationBuilders.add(new SSHKeyAuthenticationBuilder());
        logger.info("Repository configurations are reading...");
        List repositoriesConfig = this.configuration.getConfigList("repositories");
        HashSet<String> aliases = new HashSet<String>();
        RetrievalTriggerType defaultTriggerType = RetrievalTriggerType.COMPLETED;
        RetrievalType defaultRetrievalType = RetrievalType.PUBLISHED;
        boolean defaultIncludeOriginalStrings = false;
        String defaultCleanBranchesSchedule = "";
        boolean defaultCloneSingleBranch = false;
        if (this.configuration.hasPath(RETRIEVAL_TRIGGER_TYPE_CONFIG_PATH)) {
            defaultTriggerType = RetrievalTriggerType.valueOf(this.configuration.getString(RETRIEVAL_TRIGGER_TYPE_CONFIG_PATH));
        }
        if (this.configuration.hasPath(RETRIEVAL_TYPE_CONFIG_PATH)) {
            defaultRetrievalType = RetrievalType.valueOf((String)this.configuration.getString(RETRIEVAL_TYPE_CONFIG_PATH));
        }
        if (this.configuration.hasPath(INCLUDE_ORIGINAL_STRINGS_CONFIG_PATH)) {
            defaultIncludeOriginalStrings = this.configuration.getBoolean(INCLUDE_ORIGINAL_STRINGS_CONFIG_PATH);
        }
        if (this.configuration.hasPath(CLEAN_BRANCHES_SCHEDULE)) {
            defaultCleanBranchesSchedule = this.configuration.getString(CLEAN_BRANCHES_SCHEDULE);
        }
        if (this.configuration.hasPath(CLONE_SINGLE_BRANCH_CONFIG_PATH)) {
            defaultCloneSingleBranch = this.configuration.getBoolean(CLONE_SINGLE_BRANCH_CONFIG_PATH);
        }
        for (Config repositoryConfig : repositoriesConfig) {
            RepositoryType type = RepositoryType.valueOf(repositoryConfig.getString(REPOSITORY_TYPE_CONFIG_PATH));
            RepositoryKey repositoryKey = this.repositoryFactory.getKeyFromUrl(type, repositoryConfig.getString(REPOSITORY_URL_CONFIG_PATH), null);
            if (null == repositoryKey) {
                throw new ServiceException("Unsupported repository url: " + repositoryConfig.getString(REPOSITORY_URL_CONFIG_PATH));
            }
            if (this.repositoryData.containsKey(repositoryKey)) {
                throw new ServiceException("Duplicate key for repository url: " + repositoryConfig.getString(REPOSITORY_URL_CONFIG_PATH));
            }
            AuthenticationData authData = this.configToAuthenticationData(repositoryConfig);
            ProjectData projectData = this.configToProjectData(repositoryConfig, defaultTriggerType, defaultRetrievalType, defaultIncludeOriginalStrings, defaultCleanBranchesSchedule, defaultCloneSingleBranch);
            AuthenticationConfig projectAuthenticationData = this.configToProjectAuthenticationData(repositoryConfig);
            String alias = projectData.getAlias();
            if (StringUtils.isBlank(alias) || 240 < alias.length()) {
                throw new ServiceException("Repository alias " + alias + " is incorrect");
            }
            if (aliases.contains(alias)) {
                logger.warn("Duplicated aliase {} for repository {}", (Object)alias, (Object)repositoryKey);
            }
            aliases.add(alias);
            this.repositoryData.put(repositoryKey, new ImmutableTriple<AuthenticationData, ProjectData, AuthenticationConfig>(authData, projectData, projectAuthenticationData));
            logger.info("Repository {} are added, alias {}, project {}, auth type {}", new Object[]{repositoryKey, alias, projectData.getProjectId(), authData.getAuthenticationType()});
        }
        logger.info("Repository configurations are read successfully. There are {} repositories", (Object)this.repositoryData.size());
    }

    @Override
    public AuthenticationData getRepositoryData(RepositoryKey repositoryKey) {
        return this.getRepositoryConfig(repositoryKey).getLeft();
    }

    @Override
    public ProjectData getProjectData(RepositoryKey repositoryKey) {
        return this.getRepositoryConfig(repositoryKey).getMiddle();
    }

    @Override
    public AuthenticationConfig getProjectAuthenticationData(RepositoryKey repositoryKey) {
        return this.getRepositoryConfig(repositoryKey).getRight();
    }

    private Triple<AuthenticationData, ProjectData, AuthenticationConfig> getRepositoryConfig(RepositoryKey repositoryKey) {
        if (!this.repositoryData.containsKey(repositoryKey)) {
            logger.error("Can't find repository for repositoryKey: {}", (Object)repositoryKey);
            throw new ConfigurationException("Repository configuration is not found for repositoryKey: " + repositoryKey);
        }
        return this.repositoryData.get(repositoryKey);
    }

    @Override
    public Collection<RepositoryKey> getRepositoryKeys() {
        return new ArrayList<RepositoryKey>(this.repositoryData.keySet());
    }

    public void onApplicationEvent(PushRequestVoteEvent event) {
        RepositoryKey repositoryKey = event.getPushData().getRepositoryKey();
        boolean result = this.repositoryData.containsKey(repositoryKey) && this.getRepositoryConfig(repositoryKey).getMiddle().isBranchSuitable(repositoryKey.getBranch());
        event.vote(result);
        if (logger.isTraceEnabled()) {
            logger.trace("Repository url is checked for {} request, result {}", (Object)event.getRequestData().getContext(), (Object)result);
        }
    }

    private AuthenticationData configToAuthenticationData(Config repositoryConfig) {
        AuthenticationData data = new AuthenticationData();
        for (AbstractAuthenticationBuilder authenticationBuilder : this.authenticationBuilders) {
            if (!authenticationBuilder.isApplicable(repositoryConfig)) continue;
            authenticationBuilder.apply(repositoryConfig, data);
            break;
        }
        return data;
    }

    private ProjectData configToProjectData(Config repositoryConfig, RetrievalTriggerType defaultTriggerType, RetrievalType defaultRetrievalType, boolean defaultIncludeOriginalStrings, String defaultCleanBranchesSchedule, boolean defaultCloneSingleBranch) {
        ProjectData data = new ProjectData();
        data.setAlias(repositoryConfig.getString(ALIAS_CONFIG_PATH));
        data.setProjectId(repositoryConfig.getConfig(PROJECT_CONFIG_PATH).getString(PROJECT_ID_CONFIG_PATH));
        if (repositoryConfig.hasPath(BRANCHES_CONFIG_PATH)) {
            data.setBranch(repositoryConfig.getString(BRANCHES_CONFIG_PATH));
        }
        if (repositoryConfig.hasPath(POLLING_SCHEDULE_CONFIG_PATH)) {
            data.setPollingSchedule(repositoryConfig.getString(POLLING_SCHEDULE_CONFIG_PATH));
        }
        if (repositoryConfig.hasPath(SERVER_RESOURCES_CONFIG_CONFIG_PATH)) {
            data.setServerResourcesConfig(repositoryConfig.getString(SERVER_RESOURCES_CONFIG_CONFIG_PATH));
        }
        if (repositoryConfig.hasPath(RESOURCES_CONFIG_CONFIG_PATH)) {
            data.setResourcesConfig(repositoryConfig.getString(RESOURCES_CONFIG_CONFIG_PATH));
        }
        if (repositoryConfig.hasPath(LAYOUT_TRUNK_FOLDER_CONFIG_PATH)) {
            data.setTrunkFolder(repositoryConfig.getString(LAYOUT_TRUNK_FOLDER_CONFIG_PATH));
        }
        if (repositoryConfig.hasPath(LAYOUT_BRANCHES_FOLDER_CONFIG_PATH)) {
            data.setBranchesFolder(repositoryConfig.getString(LAYOUT_BRANCHES_FOLDER_CONFIG_PATH));
        }
        if (repositoryConfig.hasPath(NAMESPACE_CONFIG_PATH)) {
            data.setNamespace(repositoryConfig.getBoolean(NAMESPACE_CONFIG_PATH));
        }
        if (repositoryConfig.hasPath(RETRIEVAL_TRIGGER_TYPE_CONFIG_PATH)) {
            data.setRetrievalTriggerType(RetrievalTriggerType.valueOf(repositoryConfig.getString(RETRIEVAL_TRIGGER_TYPE_CONFIG_PATH)));
        } else {
            data.setRetrievalTriggerType(defaultTriggerType);
        }
        if (repositoryConfig.hasPath(RETRIEVAL_TYPE_CONFIG_PATH)) {
            data.setRetrievalType(RetrievalType.valueOf((String)repositoryConfig.getString(RETRIEVAL_TYPE_CONFIG_PATH)));
        } else {
            data.setRetrievalType(defaultRetrievalType);
        }
        if (repositoryConfig.hasPath(INCLUDE_ORIGINAL_STRINGS_CONFIG_PATH)) {
            data.setIncludeOriginalStrings(repositoryConfig.getBoolean(INCLUDE_ORIGINAL_STRINGS_CONFIG_PATH));
        } else {
            data.setIncludeOriginalStrings(defaultIncludeOriginalStrings);
        }
        if (repositoryConfig.hasPath(CLEAN_BRANCHES_SCHEDULE)) {
            data.setCleanBranchesSchedule(repositoryConfig.getString(CLEAN_BRANCHES_SCHEDULE));
        } else {
            data.setCleanBranchesSchedule(defaultCleanBranchesSchedule);
        }
        if (repositoryConfig.hasPath(OUTDATED_BRANCHES_DAYS)) {
            data.setOutdatedBranchesDays(repositoryConfig.getString(OUTDATED_BRANCHES_DAYS));
        }
        if (repositoryConfig.hasPath(POST_CHECKOUT_HOOK)) {
            data.setPostCheckOutHook(repositoryConfig.getString(POST_CHECKOUT_HOOK));
        }
        if (repositoryConfig.hasPath(PRE_COMMIT_HOOK)) {
            data.setPreCommitHook(repositoryConfig.getString(PRE_COMMIT_HOOK));
        }
        if (repositoryConfig.hasPath(CLONE_SINGLE_BRANCH_CONFIG_PATH)) {
            data.setCloneSingleBranch(repositoryConfig.getBoolean(CLONE_SINGLE_BRANCH_CONFIG_PATH));
        } else {
            data.setCloneSingleBranch(defaultCloneSingleBranch);
        }
        return data;
    }

    private AuthenticationConfig configToProjectAuthenticationData(Config repositoryConfig) {
        AuthenticationConfig config = new AuthenticationConfig(repositoryConfig.getConfig(PROJECT_CONFIG_PATH).getString(PROJECT_ID_CONFIG_PATH), repositoryConfig.getConfig(PROJECT_CONFIG_PATH).getString(PROJECT_USER_IDENTIFIER_CONFIG_PATH), repositoryConfig.getConfig(PROJECT_CONFIG_PATH).getString(PROJECT_TOKEN_SECRET_CONFIG_PATH));
        return config;
    }
}

