/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.vcs.data.authentication;

import com.smartling.repoconnector.model.AuthenticationData;
import com.smartling.repoconnector.model.AuthenticationType;
import com.smartling.repoconnector.services.vcs.data.authentication.AbstractAuthenticationBuilder;
import com.typesafe.config.Config;
import org.apache.commons.lang3.StringUtils;

public class SSHKeyAuthenticationBuilder
extends AbstractAuthenticationBuilder {
    private static final String PRIVATE_KEY_TOKEN = "privateKeyPath";
    private static final String PASSPHRASE_TOKEN = "passphrase";
    private static final String USER_TOKEN = "user";
    private static final String DEFAULT_USER = "git";

    public SSHKeyAuthenticationBuilder() {
        super(AuthenticationType.SSH_KEY);
    }

    @Override
    public void apply(Config repositoryConfig, AuthenticationData repositoryData) {
        repositoryData.setAuthenticationType(this.getType());
        String userKey = this.getType().getName() + ".user";
        String userValue = DEFAULT_USER;
        if (repositoryConfig.hasPath(userKey) && StringUtils.isNotEmpty(repositoryConfig.getString(userKey))) {
            userValue = repositoryConfig.getString(userKey);
        }
        String[] tokens = new String[]{repositoryConfig.getString(this.getType().getName() + ".privateKeyPath"), repositoryConfig.getString(this.getType().getName() + ".passphrase"), userValue};
        repositoryData.setTokens(tokens);
    }
}

