/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.vcs.git;

import com.smartling.repoconnector.model.AuthenticationData;
import com.smartling.repoconnector.model.ChangeType;
import com.smartling.repoconnector.model.ProjectData;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.model.RepositoryResourceChange;
import com.smartling.repoconnector.services.ServiceException;
import com.smartling.repoconnector.services.utils.RepoFileUtils;
import com.smartling.repoconnector.services.vcs.AbstractRepositoryConnector;
import com.smartling.repoconnector.services.vcs.AbstractRepositoryProtocol;
import com.smartling.repoconnector.services.vcs.Branch;
import com.smartling.repoconnector.services.vcs.data.RepositoryDataProvider;
import com.smartling.repoconnector.services.vcs.git.GitRepositoryProtocol;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.OperationResult;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="gitRepositoryConnector")
@Scope(value="prototype")
public class GitRepositoryConnector
extends AbstractRepositoryConnector {
    private static Logger logger = LoggerFactory.getLogger(GitRepositoryConnector.class);
    private static final String GIT_REPOSITORY_DIR = ".git";
    private Git contextGit;

    public GitRepositoryConnector(RepositoryKey key, AuthenticationData data, GitRepositoryProtocol protocol) {
        super(key, data, protocol);
    }

    @Override
    public boolean isRevisionBefore(String topRevision, String revision) throws ServiceException {
        boolean result = false;
        try {
            Git git = this.getGit(false);
            if (null != git && null != topRevision) {
                RevWalk walk = this.getRevWalk(git.getRepository());
                result = topRevision.equals(revision) || !RevWalkUtils.find((RevWalk)walk, (RevCommit)walk.parseCommit((AnyObjectId)ObjectId.fromString((String)topRevision)), (RevCommit)walk.parseCommit((AnyObjectId)ObjectId.fromString((String)revision))).isEmpty();
            }
        }
        catch (MissingObjectException git) {
        }
        catch (IOException e) {
            this.rethrowException(e);
        }
        return result;
    }

    @Override
    public String getTopRevision() throws ServiceException {
        String result = null;
        try {
            Git git = this.getGit(true);
            Repository rep = git.getRepository();
            Ref head = rep.findRef(rep.getFullBranch());
            result = head.getObjectId().getName();
        }
        catch (IOException e) {
            this.rethrowException(e);
        }
        return result;
    }

    @Override
    public void resetBranch() throws ServiceException {
        try {
            Git git = this.getGit(true);
            this.gitFetch(git);
            this.hardResetBranchToExternalOrigin(git);
        }
        catch (GitAPIException e) {
            this.rethrowException((Exception)((Object)e));
        }
    }

    private void gitFetch(Git git) throws GitAPIException {
        FetchCommand fetch = git.fetch();
        logger.debug("Fetching remote repository");
        this.assignCredentials((TransportCommand<?, ?>)fetch);
        FetchResult fetchResult = fetch.call();
        logger.debug("Fetch results: {}", (Object)(StringUtils.isEmpty(fetchResult.getMessages()) ? "(empty)" : fetchResult.getMessages()));
    }

    private void fetchWithRebase(Git git) throws ServiceException, GitAPIException {
        try {
            PullCommand command = git.pull();
            logger.trace("Pulling (rebasing) changes from branch=\"{}\", rev={}", (Object)command.getRepository().getBranch(), (Object)this.getCurrentRevision(git));
            this.assignCredentials((TransportCommand<?, ?>)command);
            command.setRebase(true);
            PullResult pullResult = command.call();
            logger.debug("Pull results: {}", (Object)this.prettyPrintPullResult(pullResult));
            logger.debug("Changes are pulled, rev={}", (Object)this.getCurrentRevision(git));
        }
        catch (IOException e) {
            this.rethrowException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean push(Collection<String> repositoryPaths, String commitMessage) throws ServiceException {
        block10: {
            Git git = null;
            try {
                git = this.getGit(true);
                boolean shouldBePushed = this.commitChanges(git, repositoryPaths, commitMessage);
                boolean bl = shouldBePushed = shouldBePushed || this.existLocalUnpushedCommits(git);
                if (shouldBePushed) {
                    logger.debug("There are some changes in repository that should be pushed, rev={}", (Object)this.getCurrentRevision(git));
                    PushCommand command = git.push();
                    this.assignCredentials((TransportCommand<?, ?>)command);
                    try {
                        Iterable pushResults = command.call();
                        boolean bl2 = this.processResults(pushResults);
                        return bl2;
                    }
                    catch (GitAPIException e) {
                        logger.error("Error during push command:", (Throwable)e);
                        this.hardResetBranchToExternalOrigin(git);
                        boolean bl3 = false;
                        this.logRepositoryStatus(git);
                        return bl3;
                    }
                }
                boolean bl4 = true;
                return bl4;
                {
                    catch (Exception e) {
                        this.rethrowException(e);
                        break block10;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.logRepositoryStatus(git);
            }
        }
        return false;
    }

    private boolean commitChanges(Git git, Collection<String> repositoryPaths, String commitMessage) throws Exception {
        boolean changed = false;
        for (String path : repositoryPaths) {
            git.add().addFilepattern(path).call();
            changed = changed || git.status().call().getChanged().contains(path) || git.status().call().getAdded().contains(path);
        }
        if (changed) {
            git.commit().setMessage(commitMessage).call();
            logger.debug("Local changes were committed, rev={}", (Object)this.getCurrentRevision(git));
            return true;
        }
        logger.info("There are NO changes in files from Smartling that should be committed");
        return false;
    }

    private boolean existLocalUnpushedCommits(Git git) throws IOException, ServiceException {
        boolean existUnpushed;
        Repository repository = git.getRepository();
        RevCommit originCommit = this.getCommit(repository, "origin/" + repository.getBranch());
        RevCommit latestCommit = this.getCommit(repository, repository.getFullBranch());
        boolean bl = existUnpushed = !ObjectId.toString((ObjectId)latestCommit.getId()).equals(ObjectId.toString((ObjectId)originCommit.getId())) && this.isRevisionBefore(ObjectId.toString((ObjectId)latestCommit.getId()), ObjectId.toString((ObjectId)originCommit.getId()));
        if (existUnpushed) {
            logger.warn("Local repository contains unpushed commits");
        }
        return existUnpushed;
    }

    private RevCommit getCommit(Repository repository, String refName) throws IOException, ServiceException {
        RevWalk rw = this.getRevWalk(repository);
        Ref ref = repository.findRef(refName);
        if (ref == null) {
            logger.error("Ref was not found for ref name=\"{}\"", (Object)refName);
            throw new ServiceException(String.format("Ref was not found for ref name=\"%s\"", refName));
        }
        return rw.parseCommit((AnyObjectId)ref.getObjectId());
    }

    private void logRepositoryStatus(Git git) {
        if (git != null) {
            try {
                this.logGitLastCommits(git);
            }
            catch (Exception e) {
                logger.error("Error occurred during logging commits status: {}", (Throwable)e);
            }
        } else {
            logger.error("Error has occurred. Git object is not initialized");
        }
    }

    private void logGitLastCommits(Git git) throws Exception {
        Repository repository = git.getRepository();
        RevCommit originCommit = this.getCommit(repository, "origin/" + repository.getBranch());
        RevCommit latestCommit = this.getCommit(repository, repository.getFullBranch());
        logger.trace("Branch status[ origin/{}:{}, local commit {}:{}]", new Object[]{repository.getBranch(), this.commitToString(originCommit), repository.getFullBranch(), this.commitToString(latestCommit)});
    }

    private String commitToString(RevCommit commit) {
        return commit.getId() + commit.getShortMessage();
    }

    private boolean processResults(Iterable<PushResult> pushResults) throws GitAPIException, ServiceException {
        return this.isSuccess(pushResults) || this.processUnsuccessfulPushResults(pushResults);
    }

    private boolean isSuccess(Iterable<PushResult> pushResults) {
        RemoteRefUpdate.Status status = ((RemoteRefUpdate)pushResults.iterator().next().getRemoteUpdates().iterator().next()).getStatus();
        if (status == RemoteRefUpdate.Status.OK) {
            logger.debug("Push is successful");
            return true;
        }
        logger.warn("Push is not successful. Status is {}", (Object)status);
        return false;
    }

    private boolean processUnsuccessfulPushResults(Iterable<PushResult> pushResults) throws GitAPIException, ServiceException {
        this.logOperationalResults(pushResults);
        RemoteRefUpdate.Status status = ((RemoteRefUpdate)pushResults.iterator().next().getRemoteUpdates().iterator().next()).getStatus();
        if (status == RemoteRefUpdate.Status.REJECTED_NONFASTFORWARD) {
            logger.warn("Got {} error as a result of push command", (Object)RemoteRefUpdate.Status.REJECTED_NONFASTFORWARD);
            return this.rebaseAndPushResults();
        }
        logger.warn("Could not process push results, status is {}", (Object)status);
        return false;
    }

    private boolean rebaseAndPushResults() throws GitAPIException, ServiceException {
        Git git = this.getGit(true);
        this.fetchWithRebase(git);
        logger.debug("Resolving conflict. Pulled latest changes from remote repository before pushing changes. rev={}", (Object)this.getCurrentRevision(git));
        PushCommand command = git.push();
        this.assignCredentials((TransportCommand<?, ?>)command);
        Iterable pushResults = command.call();
        logger.trace("Resolving conflict. Pushed latest changes. rev={}", (Object)this.getCurrentRevision(git));
        this.logOperationalResults(pushResults);
        return this.isSuccess(pushResults);
    }

    private <T extends OperationResult> void logOperationalResults(Iterable<T> pushResults) {
        StringBuilder stringResults = new StringBuilder();
        for (OperationResult result : pushResults) {
            stringResults.append(result.getMessages()).append(". ");
        }
        logger.debug("Operation results are '{}'", (Object)stringResults.toString());
    }

    @Override
    public File getResource(String resourcePath) {
        return new File(this.localPath(), resourcePath);
    }

    @Override
    public List<RepositoryResourceChange> getModifiedResources(String fromRevision, String path) throws ServiceException {
        try {
            Git git = this.getGit(true);
            Repository repository = git.getRepository();
            Ref head = repository.findRef(repository.getFullBranch());
            RevWalk rw = this.getRevWalk(repository);
            RevCommit commit = rw.parseCommit((AnyObjectId)head.getObjectId());
            if (StringUtils.isBlank(fromRevision)) {
                return this.getChangesForNonExistingRevision(path, repository, commit);
            }
            return this.getChangesForExistingRevision(fromRevision, path, repository, rw, commit);
        }
        catch (Exception e) {
            this.rethrowException(e);
            return Collections.emptyList();
        }
    }

    private List<RepositoryResourceChange> getChangesForExistingRevision(String fromRevision, String path, Repository repository, RevWalk rw, RevCommit commit) throws IOException {
        ArrayList<RepositoryResourceChange> changes = new ArrayList<RepositoryResourceChange>();
        RevCommit parent = rw.parseCommit((AnyObjectId)ObjectId.fromString((String)fromRevision));
        DiffFormatter df = this.getDiffFormatter(repository);
        df.setDiffComparator(RawTextComparator.DEFAULT);
        df.setDetectRenames(true);
        if (null != path) {
            String normalizedPath = new File(path).toPath().normalize().toString();
            df.setPathFilter(AndTreeFilter.create((TreeFilter)PathFilter.create((String)normalizedPath), (TreeFilter)TreeFilter.ANY_DIFF));
        }
        List diffs = df.scan(parent.getTree(), commit.getTree());
        for (DiffEntry diff : diffs) {
            changes.add(new RepositoryResourceChange(ChangeType.valueOf(diff.getChangeType().name()), diff.getOldPath(), diff.getNewPath()));
        }
        return changes;
    }

    private List<RepositoryResourceChange> getChangesForNonExistingRevision(String path, Repository repository, RevCommit commit) throws IOException {
        ArrayList<RepositoryResourceChange> changes = new ArrayList<RepositoryResourceChange>();
        try (TreeWalk tw = this.getTreeWalk(repository);){
            tw.reset();
            tw.setRecursive(true);
            tw.addTree((AnyObjectId)commit.getTree());
            if (StringUtils.isNotBlank(path)) {
                tw.setFilter(AndTreeFilter.create((TreeFilter)PathFilter.create((String)path), (TreeFilter)TreeFilter.ANY_DIFF));
            }
            while (tw.next()) {
                changes.add(new RepositoryResourceChange(ChangeType.ADD, tw.getPathString(), tw.getPathString()));
            }
        }
        return changes;
    }

    @Override
    public void close() {
        if (null != this.contextGit) {
            this.contextGit.getRepository().close();
            this.contextGit = null;
        }
        super.close();
    }

    @Override
    public boolean checkAccess() {
        boolean result = false;
        try {
            this.getBranches();
            result = true;
            logger.info("Repository is accessible");
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public List<Branch> getBranches() throws ServiceException {
        ArrayList<Branch> branches = new ArrayList<Branch>();
        try {
            String url = this.getRepositoryUrl();
            LsRemoteCommand command = this.getCheckCommand(url);
            this.assignCredentials((TransportCommand<?, ?>)command);
            for (Ref ref : command.call()) {
                if (!ref.getName().startsWith("refs/heads/")) continue;
                branches.add(new Branch(ref.getName().replace("refs/heads/", ""), ref.getObjectId().getName()));
            }
        }
        catch (Exception e) {
            this.rethrowException(e);
        }
        return branches;
    }

    @Override
    public boolean isBranchOutdated(String branchName, ProjectData projectData) throws ServiceException, IOException {
        Repository repository = this.getGit(true).getRepository();
        RevCommit originCommit = this.getCommit(repository, "origin/" + branchName);
        Date commitDate = originCommit.getAuthorIdent().getWhen();
        if (this.branchOutdateCheckNeeded(projectData)) {
            int outdateDays = Integer.parseInt(projectData.getOutdatedBranchesDays());
            DateTime dateTime = new DateTime();
            return new DateTime((Object)commitDate).isBefore((ReadableInstant)dateTime.minusDays(outdateDays));
        }
        return false;
    }

    private boolean branchOutdateCheckNeeded(ProjectData projectData) {
        return !StringUtils.isEmpty(projectData.getOutdatedBranchesDays());
    }

    protected LsRemoteCommand getCheckCommand(String url) {
        return Git.lsRemoteRepository().setRemote(url);
    }

    protected RevWalk getRevWalk(Repository repository) {
        return new RevWalk(repository);
    }

    protected TreeWalk getTreeWalk(Repository repository) {
        return new TreeWalk(repository);
    }

    protected DiffFormatter getDiffFormatter(Repository repository) {
        DiffFormatter df = new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE);
        df.setRepository(repository);
        return df;
    }

    protected Git getGit(boolean create) throws ServiceException {
        if (null == this.contextGit) {
            try {
                String localPath = this.localPath();
                File repository = new File(localPath);
                if (!repository.exists()) {
                    if (create) {
                        RepositoryDataProvider dataProvider = this.getBean(RepositoryDataProvider.class, new Object[0]);
                        ProjectData projectData = dataProvider.getProjectData(this.getKey());
                        boolean cloneSingleBranch = projectData.isCloneSingleBranch();
                        String url = this.getRepositoryUrl();
                        String branchName = this.getKey().getBranch();
                        CloneCommand command = Git.cloneRepository().setURI(url).setBranch(branchName).setDirectory(repository).setDepth(1);
                        if (cloneSingleBranch) {
                            command.setBranchesToClone(Collections.singleton("refs/heads/" + branchName)).setCloneAllBranches(false);
                        } else {
                            command.setCloneAllBranches(true);
                        }
                        this.assignCredentials((TransportCommand<?, ?>)command);
                        this.contextGit = command.call();
                        logger.info("Repository is cloned, localPath=\"{}\", cloneSingleBranch={}", (Object)localPath, (Object)cloneSingleBranch);
                    }
                } else {
                    this.contextGit = new Git((Repository)new FileRepository(FilenameUtils.concat(localPath, GIT_REPOSITORY_DIR)));
                    logger.info("Repository is opened from localPath=\"{}\"", (Object)localPath);
                    if (this.contextGit.getRepository().getBranch().equalsIgnoreCase(this.getKey().getBranch())) {
                        return this.contextGit;
                    }
                    if (this.contextGit.getRepository().getAllRefs().get("refs/heads/" + this.getKey().getBranch()) != null) {
                        this.switchCheckoutToLocalRef(this.contextGit);
                        logger.info("Repository is switched to branch=\"{}\"", (Object)("refs/heads/" + this.getKey().getBranch()));
                    } else {
                        this.switchCheckoutFromExternalOrigin(this.contextGit);
                        logger.info("Repository is switched to branch=\"{}\"", (Object)("origin/" + this.getKey().getBranch()));
                    }
                }
            }
            catch (Exception e) {
                this.rethrowException(e);
            }
        }
        return this.contextGit;
    }

    private void hardResetBranchToExternalOrigin(Git git) throws GitAPIException {
        logger.debug("Force reset branch to external origin, the current rev={}", (Object)this.getCurrentRevision(git));
        git.reset().setMode(ResetCommand.ResetType.HARD).setRef("origin/" + this.getKey().getBranch()).call();
        logger.debug("Local branch has been reset to branch=\"{}\", rev={}", (Object)this.getKey().getBranch(), (Object)this.getCurrentRevision(git));
    }

    private void hardResetCurrentBranch(Git git) throws GitAPIException {
        try {
            String currentBranchName = this.contextGit.getRepository().getBranch();
            if (currentBranchName == null) {
                return;
            }
            logger.debug("Force hard reset of current branch=\"{}\"", (Object)currentBranchName);
            git.reset().setMode(ResetCommand.ResetType.HARD).setRef("HEAD").call();
        }
        catch (IOException e) {
            logger.error("Could not determine current branch, branch reset is skipped");
        }
    }

    private void switchCheckoutFromExternalOrigin(Git git) throws GitAPIException {
        this.gitFetch(git);
        this.hardResetCurrentBranch(git);
        git.checkout().setCreateBranch(true).setName(this.getKey().getBranch()).setStartPoint("origin/" + this.getKey().getBranch()).setForced(true).call();
    }

    private void switchCheckoutToLocalRef(Git git) throws GitAPIException {
        this.hardResetCurrentBranch(git);
        git.checkout().setCreateBranch(false).setName(this.getKey().getBranch()).setStartPoint("refs/heads/" + this.getKey().getBranch()).setForced(true).call();
    }

    private void assignCredentials(TransportCommand<?, ?> command) {
        GitRepositoryProtocol gitProtocol = (GitRepositoryProtocol)this.getProtocol();
        CredentialsProvider provider = gitProtocol.getCredentialsProvider(this.getKey(), this.getData());
        if (null != provider) {
            command.setCredentialsProvider(provider);
        }
    }

    private String getCurrentRevision(Git git) {
        try {
            return git.getRepository().exactRef("HEAD").getObjectId().getName();
        }
        catch (IOException e) {
            logger.warn("Can't read revision hash", (Throwable)e);
            return "";
        }
    }

    @Override
    public String localPath() {
        return FilenameUtils.concat(this.getCloneDirectory(), RepoFileUtils.makeValidFileName(AbstractRepositoryProtocol.toIdentifierStringWithOutBranch(this.getKey())));
    }

    private String prettyPrintPullResult(PullResult pullResult) {
        StringBuilder sb = new StringBuilder();
        sb.append("isSuccessfull=").append(pullResult.isSuccessful()).append(", ");
        if (pullResult.getRebaseResult() != null) {
            sb.append(this.prettyPrintRebaseResult(pullResult.getRebaseResult()));
        } else {
            sb.append("no rebase result");
        }
        return sb.toString();
    }

    private String prettyPrintRebaseResult(RebaseResult rebaseResult) {
        StringBuilder sb = new StringBuilder();
        sb.append("rebaseResult: ");
        RebaseResult.Status status = rebaseResult.getStatus();
        sb.append("status=").append(status);
        if (!status.isSuccessful()) {
            if (CollectionUtils.isNotEmpty((Collection)rebaseResult.getConflicts())) {
                sb.append(", conflicts={ ");
                sb.append(StringUtils.join(rebaseResult.getConflicts(), " ,"));
                sb.append(" }");
            }
            if (CollectionUtils.isNotEmpty((Collection)rebaseResult.getUncommittedChanges())) {
                sb.append(", uncommittedChanges={ ");
                sb.append(StringUtils.join(rebaseResult.getUncommittedChanges(), " ,"));
                sb.append(" }");
            }
            if (rebaseResult.getCurrentCommit() != null) {
                sb.append(", currentCommit=").append(rebaseResult.getCurrentCommit());
            }
            if (MapUtils.isNotEmpty((Map)rebaseResult.getFailingPaths())) {
                sb.append(", failingPaths=");
                sb.append(StringUtils.join(rebaseResult.getFailingPaths(), " ,"));
            }
        }
        return sb.toString();
    }
}

