/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.vcs.git;

import com.google.code.regexp.Matcher;
import com.google.code.regexp.Pattern;
import com.smartling.repoconnector.model.AuthenticationData;
import com.smartling.repoconnector.model.AuthenticationType;
import com.smartling.repoconnector.model.ProtocolType;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.model.RepositoryType;
import com.smartling.repoconnector.services.vcs.AbstractRepositoryProtocol;
import com.smartling.repoconnector.services.vcs.git.SSHSession;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="gitProtocol")
public class GitRepositoryProtocol
extends AbstractRepositoryProtocol {
    protected static final String GIT_USER = "git";
    protected static final String SSH_PROTOCOL = "ssh://";
    protected static final Pattern PROTOCOL_PATTERN = Pattern.compile((String)"^(\\w+)://.*");
    protected static final Pattern PATH_STARTS_WITH_COLON = Pattern.compile((String)"\\w*(://)?.*(:\\d+)?(:[^\\d+/?].*)$");
    @Autowired
    private SSHSession session;

    @Override
    public RepositoryKey getKeyFromUrl(RepositoryType type, String repositoryUrl, String branch) {
        RepositoryKey key = null;
        if (RepositoryType.GIT.equals((Object)type)) {
            String uriString = GitRepositoryProtocol.adjustRepositoryUrl(repositoryUrl);
            try {
                URI uri = new URI(uriString);
                key = new RepositoryKey(type, ProtocolType.getType(uri.getScheme()), uri.getHost() + GitRepositoryProtocol.getPortAsString(uri.getPort()), GitRepositoryProtocol.removeFirstSlash(uri.getPath()), branch);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return key;
    }

    @Override
    public boolean isApplicable(RepositoryKey key, AuthenticationData data) {
        return RepositoryType.GIT.equals((Object)key.getType()) && (null == data.getAuthenticationType() || AuthenticationType.USER_PASSWORD.equals((Object)data.getAuthenticationType()) && null != data.getTokens() && 2 == data.getTokens().length || AuthenticationType.SSH_KEY.equals((Object)data.getAuthenticationType()) && null != data.getTokens() && 3 == data.getTokens().length || AuthenticationType.PERSONAL_TOKEN.equals((Object)data.getAuthenticationType()) && null != data.getTokens() && 1 == data.getTokens().length);
    }

    @Override
    public String getRepositoryUrl(RepositoryKey key, AuthenticationData authData) {
        Object url = null;
        if (ProtocolType.SSH.equals((Object)key.getProtocol()) && !AuthenticationType.SSH_KEY.equals((Object)authData.getAuthenticationType())) {
            url = ProtocolType.HTTPS.getName() + "://" + key.getHost() + "/" + key.getPath();
        } else if (AuthenticationType.SSH_KEY.equals((Object)authData.getAuthenticationType())) {
            String user = StringUtils.isNotEmpty(authData.getTokens()[2]) ? authData.getTokens()[2] : GIT_USER;
            url = ProtocolType.SSH.getName() + "://" + user + "@" + key.getHost() + "/" + key.getPath();
        }
        return null == url ? super.getRepositoryUrl(key, authData) : url;
    }

    public CredentialsProvider getCredentialsProvider(RepositoryKey key, AuthenticationData credential) {
        UsernamePasswordCredentialsProvider provider = null;
        if (null != credential && null != credential.getAuthenticationType()) {
            if (AuthenticationType.PERSONAL_TOKEN.equals((Object)credential.getAuthenticationType())) {
                provider = new UsernamePasswordCredentialsProvider(GIT_USER, credential.getTokens()[0]);
            } else if (!AuthenticationType.SSH_KEY.equals((Object)credential.getAuthenticationType()) && !AuthenticationType.HTTP.equals((Object)credential.getAuthenticationType())) {
                provider = new UsernamePasswordCredentialsProvider(credential.getTokens()[0], credential.getTokens()[1]);
            }
        }
        return provider;
    }

    @Override
    public void onOpenConnector(RepositoryKey key, AuthenticationData data) {
        if (AuthenticationType.SSH_KEY.equals((Object)data.getAuthenticationType())) {
            this.session.setContextTokens(data.getTokens()[0], data.getTokens()[1]);
        }
    }

    @Override
    public void onCloseConnector(RepositoryKey key, AuthenticationData data) {
        this.session.setContextTokens(null, null);
    }

    private static String getPortAsString(int port) {
        return port > -1 ? ":" + port : "";
    }

    private static String removeFirstSlash(String path) {
        return StringUtils.isNotEmpty(path) && path.startsWith("/") ? path.replaceFirst("/", "") : path;
    }

    private static String adjustRepositoryUrl(String repositoryUrl) {
        Object uriString = repositoryUrl;
        Matcher matcher = PROTOCOL_PATTERN.matcher((CharSequence)repositoryUrl);
        if (!matcher.matches()) {
            uriString = SSH_PROTOCOL + (String)uriString;
        }
        if (repositoryUrl.contains("@")) {
            uriString = new StringBuilder((String)uriString).replace(((String)uriString).indexOf("://") + 3, ((String)uriString).indexOf("@") + 1, "").toString();
        }
        if ((matcher = PATH_STARTS_WITH_COLON.matcher((CharSequence)uriString)).matches()) {
            uriString = new StringBuilder((String)uriString).replace(((String)uriString).lastIndexOf(":"), ((String)uriString).lastIndexOf(":") + 1, "/").toString();
        }
        return uriString;
    }
}

