/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.vcs.git;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import jakarta.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.internal.transport.ssh.jsch.CredentialsProviderUserInfo;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.ssh.jsch.JschConfigSessionFactory;
import org.eclipse.jgit.transport.ssh.jsch.OpenSshConfig;
import org.eclipse.jgit.util.FS;
import org.springframework.stereotype.Component;

@Component
public class SSHSession
extends JschConfigSessionFactory {
    private ThreadLocal<Pair<String, String>> sshToken = new ThreadLocal();

    @PostConstruct
    public void init() {
        SshSessionFactory.setInstance((SshSessionFactory)this);
    }

    protected void configure(OpenSshConfig.Host hc, Session session) {
        CredentialsProvider provider = new CredentialsProvider(){

            public boolean isInteractive() {
                return false;
            }

            public boolean supports(CredentialItem ... items) {
                return true;
            }

            public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
                Pair<String, String> tokens = SSHSession.this.sshToken.get();
                for (CredentialItem item : items) {
                    if (item instanceof CredentialItem.YesNoType) {
                        ((CredentialItem.YesNoType)item).setValue(true);
                        continue;
                    }
                    if (item instanceof CredentialItem.StringType) {
                        ((CredentialItem.StringType)item).setValue(tokens.getValue());
                        continue;
                    }
                    ((CredentialItem.Password)item).setValue(tokens.getValue().toCharArray());
                }
                return true;
            }
        };
        CredentialsProviderUserInfo userInfo = new CredentialsProviderUserInfo(session, provider);
        session.setUserInfo((UserInfo)userInfo);
        session.setConfig("StrictHostKeyChecking", "no");
    }

    protected JSch getJSch(OpenSshConfig.Host hc, FS fs) throws JSchException {
        JSch jsch = super.getJSch(hc, fs);
        jsch.removeAllIdentity();
        Pair<String, String> tokens = this.sshToken.get();
        if (null != tokens) {
            jsch.addIdentity(tokens.getKey(), tokens.getValue());
        }
        return jsch;
    }

    public void setContextTokens(String path, String token) {
        if (StringUtils.isBlank(path) && StringUtils.isBlank(token)) {
            this.sshToken.remove();
        } else {
            this.sshToken.set(new ImmutablePair<String, String>(path, token));
        }
    }
}

