/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.vcs.resources;

import com.smartling.api.files.v2.pto.FileType;
import com.smartling.repoconnector.model.RepositoryResourcesSet;
import com.smartling.repoconnector.services.vcs.resources.ResourcesConfiguration;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigSyntax;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ResourcesConfigurationImpl
implements ResourcesConfiguration {
    private static Logger logger = LoggerFactory.getLogger(ResourcesConfigurationImpl.class);
    private static final String RESOURCES_CONFIG_PATH = "resourceSets";
    private static final String PATH_PATTERN_NAME = "pathRegex";
    private static final String TYPE_NAME = "type";
    private static final String CALLBACK_URL_NAME = "callbackUrl";
    private static final String AUTHORIZE_CONTENT_NAME = "authorizeContent";
    private static final String PATH_EXPRESSION_NAME = "translationPathExpression";
    private static final String COMMIT_MESSAGE_NAME = "translationCommitMessage";
    private static final String ADDITIONAL_DIRECTIVES_NAME = "smartlingDirectives";
    private static final String LOCALES_CONFIG_PATH = "locales";
    private static final String SMARTLING_LOCALE_ID = "smartling";
    private static final String CUSTOM_LOCALE_ID = "application";
    @Value(value="${smartling.localePattern}")
    private String smartlingLocalePattern;
    @Value(value="${smartling.clientLocalePattern}")
    private String customLocalePattern;
    private File inputFile;
    private List<RepositoryResourcesSet> resourcesSets = new ArrayList<RepositoryResourcesSet>();

    public ResourcesConfigurationImpl(File inputFile) {
        this.inputFile = inputFile;
    }

    @Override
    public List<RepositoryResourcesSet> getResourcesSets() {
        return this.resourcesSets;
    }

    @PostConstruct
    public void readConfiguration() {
        Config resourcesConfig = ConfigFactory.parseFile((File)this.inputFile, (ConfigParseOptions)ConfigParseOptions.defaults().setSyntax(ConfigSyntax.CONF));
        Map<String, String> locales = this.getLocalesMap(resourcesConfig);
        if (!locales.isEmpty()) {
            List setsConfigs = resourcesConfig.getConfigList(RESOURCES_CONFIG_PATH);
            for (Config setConfig : setsConfigs) {
                FileType fileType = FileType.lookup((String)setConfig.getString(TYPE_NAME));
                if (fileType == null) {
                    throw new IllegalArgumentException("Unsupported file type \"" + setConfig.getString(TYPE_NAME) + "\" in the set config");
                }
                RepositoryResourcesSet set = new RepositoryResourcesSet(setConfig.getString(PATH_PATTERN_NAME), fileType, locales);
                if (setConfig.hasPath(CALLBACK_URL_NAME)) {
                    set.setCallbackUrl(setConfig.getString(CALLBACK_URL_NAME));
                }
                if (setConfig.hasPath(AUTHORIZE_CONTENT_NAME)) {
                    set.setAuthorizeContent(setConfig.getBoolean(AUTHORIZE_CONTENT_NAME));
                }
                if (setConfig.hasPath(PATH_EXPRESSION_NAME)) {
                    set.setPathExpression(setConfig.getString(PATH_EXPRESSION_NAME));
                }
                if (setConfig.hasPath(COMMIT_MESSAGE_NAME)) {
                    set.setCommitMessage(setConfig.getString(COMMIT_MESSAGE_NAME));
                }
                if (setConfig.hasPath(LOCALES_CONFIG_PATH)) {
                    set.setLocalesMapping(this.getLocalesMap(setConfig));
                }
                if (setConfig.hasPath(ADDITIONAL_DIRECTIVES_NAME)) {
                    HashMap<String, String> directives = new HashMap<String, String>();
                    for (String directive : setConfig.getStringList(ADDITIONAL_DIRECTIVES_NAME)) {
                        String[] pair = directive.split("=", 2);
                        if (2 == pair.length) {
                            directives.put(pair[0].trim(), pair[1].trim());
                            continue;
                        }
                        logger.warn("Invalid format of the additional directive: {}", (Object)directive);
                    }
                    set.setAdditionalDirectives(directives);
                }
                this.resourcesSets.add(set);
            }
        } else {
            logger.warn("There is no locales in file {}", (Object)this.inputFile.getPath());
        }
        logger.info("Resources configuration read from {}, there are {} sets", (Object)this.inputFile.getPath(), (Object)this.resourcesSets.size());
    }

    private Map<String, String> getLocalesMap(Config resourcesConfig) {
        HashMap<String, String> locales = new HashMap<String, String>();
        List localesConfigs = resourcesConfig.getConfigList(LOCALES_CONFIG_PATH);
        for (Config localeConfig : localesConfigs) {
            String smartlingId = localeConfig.getString(SMARTLING_LOCALE_ID);
            String customId = localeConfig.getString(CUSTOM_LOCALE_ID);
            if (StringUtils.isBlank(smartlingId) || StringUtils.isBlank(customId) || !smartlingId.matches(this.smartlingLocalePattern) || !customId.matches(this.customLocalePattern)) {
                logger.warn("Wrong locale mapping {} - {}. This locale is ignored!", (Object)smartlingId, (Object)customId);
                continue;
            }
            locales.put(smartlingId, customId);
        }
        return locales;
    }
}

