/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.vcs.svn;

import com.smartling.repoconnector.model.AuthenticationData;
import com.smartling.repoconnector.model.ChangeType;
import com.smartling.repoconnector.model.ProjectData;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.model.RepositoryResourceChange;
import com.smartling.repoconnector.services.ServiceException;
import com.smartling.repoconnector.services.vcs.AbstractRepositoryConnector;
import com.smartling.repoconnector.services.vcs.Branch;
import com.smartling.repoconnector.services.vcs.RepositoryFactory;
import com.smartling.repoconnector.services.vcs.svn.SvnRepositoryProtocol;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

@Service(value="svnRepositoryConnector")
@Scope(value="prototype")
public class SvnRepositoryConnector
extends AbstractRepositoryConnector {
    private static final String TRUNK_NAME = "trunk";
    private static Logger logger = LoggerFactory.getLogger(SvnRepositoryConnector.class);
    private String trunkFolder = "trunk";
    private String branchesFolder = "branches";
    private SVNClientManager clientManager;

    public SvnRepositoryConnector(RepositoryKey key, AuthenticationData data, SvnRepositoryProtocol protocol) {
        super(key, data, protocol);
        this.clientManager = this.createClientManager(protocol.getAuthenticationManager(key, data));
    }

    @Override
    public void init() {
        super.init();
        ProjectData data = this.getBean(RepositoryFactory.class, new Object[0]).getProjectData(this.getKey());
        this.trunkFolder = StringUtils.isNoneBlank(data.getTrunkFolder()) ? data.getTrunkFolder() : this.trunkFolder;
        this.branchesFolder = StringUtils.isNoneBlank(data.getBranchesFolder()) ? data.getBranchesFolder() : this.branchesFolder;
    }

    @Override
    public boolean isRevisionBefore(String topRevision, String revision) throws ServiceException {
        MutableBoolean result = new MutableBoolean(false);
        File cloneDirectory = new File(this.localPath());
        if (StringUtils.isNotBlank(topRevision) && cloneDirectory.exists()) {
            result.setValue(SVNRevision.parse((String)revision).getNumber() < SVNRevision.parse((String)topRevision).getNumber());
        }
        return result.booleanValue();
    }

    @Override
    public void resetBranch() throws ServiceException {
        try {
            SVNUpdateClient updateClient = this.clientManager.getUpdateClient();
            String cloneDirectory = this.localPath();
            if (new File(cloneDirectory).exists()) {
                this.clientManager.getWCClient().doCleanup(new File(this.localPath()));
                updateClient.doUpdate(new File(cloneDirectory), SVNRevision.HEAD, SVNDepth.INFINITY, false, false);
            } else {
                updateClient.doCheckout(SVNURL.parseURIEncoded((String)this.getRepositoryUrl()).appendPath(this.getBranchPath(), true), new File(cloneDirectory), null, SVNRevision.HEAD, SVNDepth.INFINITY, false);
            }
        }
        catch (SVNException e) {
            this.rethrowException((Exception)((Object)e));
        }
    }

    @Override
    public boolean push(Collection<String> repositoryPaths, String commitMessage) throws ServiceException {
        String clonePath = this.localPath();
        ArrayList<File> commitFiles = new ArrayList<File>();
        try {
            this.clientManager.getWCClient().doCleanup(new File(this.localPath()));
            for (String repositoryPath : repositoryPaths) {
                File translationFile = new File(this.localPath(), repositoryPath);
                File parent = translationFile.getParentFile();
                while (!clonePath.equals(parent.getPath())) {
                    commitFiles.add(parent);
                    parent = parent.getParentFile();
                }
                SVNStatusClient statusClient = this.clientManager.getStatusClient();
                for (File path : commitFiles) {
                    if (!SVNStatusType.STATUS_UNVERSIONED.equals(statusClient.doStatus(path, false).getNodeStatus())) continue;
                    this.clientManager.getWCClient().doAdd(parent, true, false, true, SVNDepth.INFINITY, false, true);
                }
                SVNStatus status = this.clientManager.getStatusClient().doStatus(translationFile, false);
                if (SVNStatusType.STATUS_UNVERSIONED.equals(status.getNodeStatus())) {
                    this.clientManager.getWCClient().doAdd(translationFile, true, false, true, SVNDepth.EMPTY, false, true);
                    commitFiles.add(translationFile);
                    continue;
                }
                if (!SVNStatusType.STATUS_MODIFIED.equals(status.getNodeStatus()) && !SVNStatusType.STATUS_ADDED.equals(status.getNodeStatus())) continue;
                commitFiles.add(translationFile);
            }
            if (!commitFiles.isEmpty()) {
                this.clientManager.getCommitClient().doCommit(commitFiles.toArray(new File[0]), false, commitMessage, null, null, false, true, SVNDepth.INFINITY);
            }
        }
        catch (SVNException e) {
            this.rethrowException((Exception)((Object)e));
        }
        return 0 < commitFiles.size();
    }

    @Override
    public List<Branch> getBranches() throws ServiceException {
        final ArrayList<Branch> branches = new ArrayList<Branch>();
        try {
            this.clientManager.getLogClient().doList(SVNURL.parseURIEncoded((String)this.getRepositoryUrl()).appendPath(this.branchesFolder, true), SVNRevision.HEAD, SVNRevision.HEAD, false, SVNDepth.IMMEDIATES, -1, new ISVNDirEntryHandler(){

                public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
                    if (StringUtils.isNoneBlank(dirEntry.getName())) {
                        branches.add(new Branch(dirEntry.getName(), Long.toString(dirEntry.getRevision())));
                    }
                }
            });
            this.clientManager.getLogClient().doList(SVNURL.parseURIEncoded((String)this.getRepositoryUrl()).appendPath(this.trunkFolder, true), SVNRevision.HEAD, SVNRevision.HEAD, false, SVNDepth.IMMEDIATES, -1, new ISVNDirEntryHandler(){

                public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
                    if (StringUtils.isBlank(dirEntry.getName())) {
                        branches.add(new Branch(SvnRepositoryConnector.TRUNK_NAME, Long.toString(dirEntry.getRevision())));
                    }
                }
            });
        }
        catch (SVNException e) {
            this.rethrowException((Exception)((Object)e));
        }
        return branches;
    }

    @Override
    public String getTopRevision() throws ServiceException {
        String result = null;
        try {
            File cloneDirectory = new File(this.localPath());
            SVNStatus head = this.clientManager.getStatusClient().doStatus(cloneDirectory, false);
            result = Long.toString(head.getCommittedRevision().getNumber());
        }
        catch (SVNException e) {
            this.rethrowException((Exception)((Object)e));
        }
        return result;
    }

    @Override
    public File getResource(String resourcePath) {
        return new File(this.localPath(), resourcePath);
    }

    @Override
    public List<RepositoryResourceChange> getModifiedResources(String fromRevision, String path) throws ServiceException {
        final ArrayList<RepositoryResourceChange> changes = new ArrayList<RepositoryResourceChange>();
        try {
            String cloneDirectory = this.localPath();
            if (StringUtils.isBlank(fromRevision)) {
                this.clientManager.getLogClient().doList(new File(StringUtils.isBlank(path) ? cloneDirectory : FilenameUtils.concat(cloneDirectory, path)), null, SVNRevision.HEAD, false, SVNDepth.INFINITY, -1, new ISVNDirEntryHandler(){

                    public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
                        if (SVNNodeKind.FILE.equals(dirEntry.getKind())) {
                            changes.add(new RepositoryResourceChange(ChangeType.ADD, dirEntry.getRelativePath(), dirEntry.getRelativePath()));
                        }
                    }
                });
            } else {
                final HashMap resources = new HashMap();
                this.clientManager.getLogClient().doLog(new File[]{new File(StringUtils.isBlank(path) ? cloneDirectory : FilenameUtils.concat(cloneDirectory, path))}, SVNRevision.create((long)(Long.parseLong(fromRevision) + 1L)), SVNRevision.WORKING, false, true, -1L, new ISVNLogEntryHandler(){

                    public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                        for (Map.Entry change : logEntry.getChangedPaths().entrySet()) {
                            if (!SVNNodeKind.FILE.equals(((SVNLogEntryPath)change.getValue()).getKind())) continue;
                            ChangeType newType = SvnRepositoryConnector.this.getChangeType(((SVNLogEntryPath)change.getValue()).getType());
                            String path = SvnRepositoryConnector.this.getRelativePath((String)change.getKey());
                            RepositoryResourceChange prev = (RepositoryResourceChange)resources.get(path);
                            ChangeType prevType = null == prev ? null : prev.getType();
                            RepositoryResourceChange newChange = null;
                            if (ChangeType.ADD.equals((Object)prevType)) {
                                if (ChangeType.DELETE.equals((Object)newType)) {
                                    resources.remove(change.getKey());
                                } else {
                                    newChange = prev;
                                }
                            } else {
                                newChange = ChangeType.DELETE.equals((Object)prevType) ? new RepositoryResourceChange(ChangeType.MODIFY, prev.getOldPath(), path) : new RepositoryResourceChange(newType, SvnRepositoryConnector.this.getRelativePath(((SVNLogEntryPath)change.getValue()).getPath()), path);
                            }
                            if (null == newChange) continue;
                            resources.put((String)change.getKey(), newChange);
                        }
                    }
                });
                changes.addAll(resources.values());
            }
        }
        catch (SVNException e) {
            this.rethrowException((Exception)((Object)e));
        }
        return changes;
    }

    @Override
    public boolean checkAccess() {
        boolean result = false;
        try {
            this.getBranches();
            result = true;
            logger.info("Repository is accessible");
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public boolean isBranchOutdated(String branchName, ProjectData projectData) throws ServiceException, IOException {
        return false;
    }

    @Override
    public void close() {
        this.clientManager.dispose();
        super.close();
    }

    protected SVNClientManager createClientManager(ISVNAuthenticationManager authenticationManager) {
        return SVNClientManager.newInstance(null, (ISVNAuthenticationManager)authenticationManager);
    }

    private String getBranchPath() {
        Object path = this.trunkFolder;
        if (!TRUNK_NAME.equals(this.getKey().getBranch())) {
            path = this.branchesFolder + "/" + this.getKey().getBranch();
        }
        return path;
    }

    private ChangeType getChangeType(char changeType) {
        switch (changeType) {
            case 'A': {
                return ChangeType.ADD;
            }
            case 'D': {
                return ChangeType.DELETE;
            }
            case 'M': {
                return ChangeType.MODIFY;
            }
            case 'R': {
                return ChangeType.MODIFY;
            }
        }
        return null;
    }

    private String getRelativePath(String path) {
        String result = path;
        String prefix = "/" + this.getBranchPath() + "/";
        int index = path.indexOf(prefix);
        if (-1 != index) {
            if (0 == index) {
                result = path.substring(prefix.length());
            } else {
                String repositoryPath = this.getKey().getPath().replaceAll("/+$", "");
                if (repositoryPath.endsWith(path.substring(0, index))) {
                    result = result.substring(index + prefix.length());
                }
            }
        }
        return result;
    }
}

