/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.vcs.svn;

import com.smartling.repoconnector.model.AuthenticationData;
import com.smartling.repoconnector.model.AuthenticationType;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.model.RepositoryType;
import com.smartling.repoconnector.services.vcs.AbstractRepositoryProtocol;
import org.springframework.stereotype.Component;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;

@Component(value="svnProtocol")
public class SvnRepositoryProtocol
extends AbstractRepositoryProtocol {
    @Override
    public RepositoryKey getKeyFromUrl(RepositoryType type, String repositoryUrl, String branch) {
        return RepositoryType.SVN.equals((Object)type) ? super.getKeyFromUrl(type, repositoryUrl, branch) : null;
    }

    @Override
    public boolean isApplicable(RepositoryKey key, AuthenticationData data) {
        return RepositoryType.SVN.equals((Object)key.getType());
    }

    public ISVNAuthenticationManager getAuthenticationManager(RepositoryKey key, AuthenticationData credential) {
        BasicAuthenticationManager authManager = null;
        if (AuthenticationType.USER_PASSWORD.equals((Object)credential.getAuthenticationType())) {
            authManager = new BasicAuthenticationManager(new SVNAuthentication[]{new SVNPasswordAuthentication(credential.getTokens()[0], credential.getTokens()[1], false, null, false)});
        }
        return authManager;
    }
}

