/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.connectors.appenders.core;

import com.smartling.connectors.appenders.core.LogClient;
import com.smartling.connectors.appenders.core.LogMessage;
import java.util.ArrayList;
import java.util.List;

public class BufferedAppender {
    private final LogClient logClient;
    private final int bufferMaxSize;
    private final List<LogMessage> buffer;

    public BufferedAppender(LogClient logClient, int bufferMaxSize) {
        this.logClient = logClient;
        this.bufferMaxSize = bufferMaxSize;
        this.buffer = new ArrayList<LogMessage>(bufferMaxSize);
    }

    synchronized void append(LogMessage message) {
        this.buffer.add(message);
        this.flush(FlushMode.DEFAULT_FLUSH);
    }

    public void close() {
        this.flush(FlushMode.FORCE_FLUSH);
    }

    public synchronized void flush(FlushMode mode) {
        if (!(this.buffer.isEmpty() || this.buffer.size() != this.bufferMaxSize && mode != FlushMode.FORCE_FLUSH)) {
            this.logClient.sendLogMessages(this.buffer);
            this.buffer.clear();
        }
    }

    public static enum FlushMode {
        FORCE_FLUSH,
        DEFAULT_FLUSH;

    }
}

