/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.connectors.appenders.core;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.smartling.connectors.appenders.core.LogMessage;
import com.smartling.connectors.appenders.core.ProxyConfiguration;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class LogClient {
    private final String logServiceUrl;
    private final String userAgent;
    private final Gson gson;
    private final ProxyConfiguration proxyConfiguration;

    public LogClient(String logServiceUrl, String userAgent) {
        this(logServiceUrl, userAgent, null);
    }

    public LogClient(String logServiceUrl, String userAgent, ProxyConfiguration proxyConfiguration) {
        this.logServiceUrl = logServiceUrl;
        this.userAgent = userAgent;
        this.proxyConfiguration = proxyConfiguration;
        this.gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    }

    public void sendLogMessages(Collection<LogMessage> messages) {
        try (CloseableHttpClient client = this.getHttpClient();){
            HttpPost httpPost = new HttpPost(this.logServiceUrl);
            this.configurePostMethod(messages, httpPost);
            client.execute((ClassicHttpRequest)httpPost, response -> null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private CloseableHttpClient getHttpClient() throws KeyManagementException, NoSuchAlgorithmException {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (this.proxyConfiguration != null && StringUtils.isNotEmpty((CharSequence)this.proxyConfiguration.getUsername()) && StringUtils.isNotEmpty((CharSequence)this.proxyConfiguration.getPassword())) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(this.proxyConfiguration.getHost(), this.proxyConfiguration.getPort()), (Credentials)new UsernamePasswordCredentials(this.proxyConfiguration.getUsername(), this.proxyConfiguration.getPassword().toCharArray()));
            httpClientBuilder = httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy((TlsSocketStrategy)new DefaultClientTlsStrategy(this.getSSLConfig())).build());
        if (this.proxyConfiguration != null) {
            HttpHost proxyHttpHost = new HttpHost("http", this.proxyConfiguration.getHost(), this.proxyConfiguration.getPort());
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyHttpHost);
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        }
        return httpClientBuilder.build();
    }

    private SSLContext getSSLConfig() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(null, null, null);
        return sslContext;
    }

    private void configurePostMethod(Collection<LogMessage> messages, HttpPost httpPost) {
        String json = this.toJson(messages);
        StringEntity entity = new StringEntity(json);
        httpPost.setEntity((HttpEntity)entity);
        httpPost.setHeader("Accept", (Object)"application/json");
        httpPost.setHeader("Content-type", (Object)"application/json");
        httpPost.setHeader("User-Agent", (Object)this.userAgent);
    }

    private String toJson(Collection<LogMessage> messages) {
        JsonElement je = this.gson.toJsonTree(messages);
        JsonObject jo = new JsonObject();
        jo.add("records", je);
        return jo.toString();
    }
}

