/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.connectors.appenders.core;

import com.smartling.connectors.appenders.core.BlockingQueueFactory;
import com.smartling.connectors.appenders.core.LogMessage;
import com.smartling.connectors.appenders.core.QueueListenerFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class QueueAppender {
    private static ExecutorService threadPool = Executors.newCachedThreadPool();
    private final BlockingQueue<LogMessage> queue;
    private final AtomicBoolean start = new AtomicBoolean(false);
    private final QueueListenerFactory queueListenerFactory;

    public QueueAppender(BlockingQueueFactory queueFactory, QueueListenerFactory queueListenerFactory) {
        this.queueListenerFactory = queueListenerFactory;
        this.queue = queueFactory.create();
    }

    public void log(LogMessage message) {
        this.queue.offer(message);
        if (this.start.compareAndSet(false, true)) {
            this.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ExecutorService executorService = threadPool;
        synchronized (executorService) {
            if (!threadPool.isShutdown()) {
                QueueAppender.shutdownAndAwaitTermination(threadPool);
            }
        }
    }

    private void execute() {
        if (threadPool.isShutdown()) {
            threadPool = Executors.newCachedThreadPool();
        }
        Runnable listener = this.queueListenerFactory.create(this, this.queue);
        threadPool.execute(listener);
    }

    private static void shutdownAndAwaitTermination(ExecutorService pool) {
        pool.shutdownNow();
        try {
            if (!QueueAppender.awaitTerminationWithAttempts(pool, 5, 12)) {
                System.out.println(pool.toString());
                pool.shutdownNow();
                if (!QueueAppender.awaitTerminationWithAttempts(pool, 5, 12)) {
                    System.err.println("Pool did not terminate");
                }
            }
            System.out.println(pool.toString());
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static boolean awaitTerminationWithAttempts(ExecutorService pool, int attemptTimeout, int attemptCount) throws InterruptedException {
        boolean terminated = false;
        for (int counter = 0; !terminated && counter < attemptCount; ++counter) {
            terminated = pool.awaitTermination(attemptTimeout, TimeUnit.SECONDS);
        }
        return terminated;
    }
}

