/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.connectors.appenders.core;

import com.smartling.connectors.appenders.core.BufferedAppender;
import com.smartling.connectors.appenders.core.LogMessage;
import com.smartling.connectors.appenders.core.QueueAppender;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class QueueListener
implements Runnable {
    private final BlockingQueue<LogMessage> queue;
    private final BufferedAppender bufferedAppender;
    private final QueueAppender caller;
    private final long bufferTimeThreshold;

    public QueueListener(QueueAppender caller, BlockingQueue<LogMessage> queue, BufferedAppender bufferedAppender, long bufferTimeThreshold) {
        this.queue = queue;
        this.bufferedAppender = bufferedAppender;
        this.caller = caller;
        this.bufferTimeThreshold = bufferTimeThreshold;
    }

    @Override
    public void run() {
        try {
            while (!Thread.interrupted()) {
                long timeBefore;
                long timeAfter;
                for (long threshold = this.bufferTimeThreshold; threshold > 0L; threshold -= timeAfter - timeBefore) {
                    timeBefore = new Date().getTime();
                    LogMessage message = this.queue.poll(threshold, TimeUnit.MILLISECONDS);
                    if (message != null) {
                        this.bufferedAppender.append(message);
                    }
                    timeAfter = new Date().getTime();
                }
                this.bufferedAppender.flush(BufferedAppender.FlushMode.FORCE_FLUSH);
            }
        }
        catch (InterruptedException threshold) {
        }
        catch (Exception e) {
            this.caller.close();
        }
    }
}

