/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.connectors.appenders.log4j2;

import com.smartling.connectors.appenders.core.BlockingQueueFactory;
import com.smartling.connectors.appenders.core.BufferedAppender;
import com.smartling.connectors.appenders.core.LogClient;
import com.smartling.connectors.appenders.core.LogMessage;
import com.smartling.connectors.appenders.core.ProxyConfiguration;
import com.smartling.connectors.appenders.core.QueueAppender;
import com.smartling.connectors.appenders.core.QueueListener;
import com.smartling.connectors.appenders.core.QueueListenerFactory;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.util.NetUtils;

@Plugin(name="SmartlingExternalAppender", category="Core", elementType="appender", printObject=true)
public class SmartlingExternalAppender
extends AbstractAppender {
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private QueueAppender asyncQueueAppender;
    private BufferedAppender bufferedAppender;
    private String logServiceUrl = "https://api.smartling.com/updates/status";
    private String host;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private String channel;
    private Layout<? extends Serializable> layout;
    private int queueSize = 100;
    private int bufferTimeThreshold = 1000;
    private int bufferMaxSize = 50;

    public SmartlingExternalAppender(String name, Filter filter, String logServiceUrl, String host, String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, String channel, Layout<? extends Serializable> layout, int queueSize, int bufferTimeThreshold, int bufferMaxSize) {
        super(name, filter, layout);
        this.logServiceUrl = logServiceUrl;
        this.host = StringUtils.isNotEmpty((CharSequence)host) ? host : NetUtils.getLocalHostname();
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword;
        this.channel = channel;
        this.layout = layout;
        this.queueSize = queueSize;
        this.bufferTimeThreshold = bufferTimeThreshold;
        this.bufferMaxSize = bufferMaxSize;
        this.addFilter((Filter)ThresholdFilter.createFilter((Level)Level.DEBUG, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.DENY));
    }

    protected SmartlingExternalAppender(String name, Filter filter, Layout<? extends Serializable> layout) {
        super(name, filter, layout);
        this.layout = layout;
    }

    protected SmartlingExternalAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
        this.layout = layout;
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public void start() {
        LogClient logClient;
        super.start();
        String userAgent = "SmartlingExternalAppender/" + ((Object)((Object)this)).getClass().getPackage().getImplementationVersion();
        if (StringUtils.isNotEmpty((CharSequence)this.proxyHost) && this.proxyPort != null) {
            ProxyConfiguration proxyConfiguration = new ProxyConfiguration();
            proxyConfiguration.setHost(this.proxyHost);
            proxyConfiguration.setPort(this.proxyPort);
            proxyConfiguration.setUsername(this.proxyUser);
            proxyConfiguration.setPassword(this.proxyPassword);
            logClient = new LogClient(this.logServiceUrl, userAgent, proxyConfiguration);
        } else {
            logClient = new LogClient(this.logServiceUrl, userAgent);
        }
        this.bufferedAppender = new BufferedAppender(logClient, this.bufferMaxSize);
        BlockingQueueFactory blockingQueueFactory = new BlockingQueueFactory(){

            @Override
            public BlockingQueue<LogMessage> create() {
                return new ArrayBlockingQueue<LogMessage>(SmartlingExternalAppender.this.queueSize);
            }
        };
        QueueListenerFactory queueListenerFactory = new QueueListenerFactory(){

            @Override
            public QueueListener create(QueueAppender queueAppender, BlockingQueue<LogMessage> queue) {
                return new QueueListener(queueAppender, queue, SmartlingExternalAppender.this.bufferedAppender, SmartlingExternalAppender.this.bufferTimeThreshold);
            }
        };
        this.asyncQueueAppender = new QueueAppender(blockingQueueFactory, queueListenerFactory);
    }

    public void append(LogEvent event) {
        if (this.asyncQueueAppender != null) {
            LogMessage logMessage = this.createLogMessage(event);
            this.asyncQueueAppender.log(logMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop(long timeout, TimeUnit timeUnit) {
        try {
            boolean bl = super.stop(timeout, timeUnit);
            return bl;
        }
        finally {
            if (this.asyncQueueAppender != null) {
                this.asyncQueueAppender.close();
            }
            if (this.bufferedAppender != null) {
                this.bufferedAppender.close();
            }
        }
    }

    private LogMessage createLogMessage(LogEvent event) {
        LogMessage message = new LogMessage();
        message.setLevelName(event.getLevel().name());
        message.setChannel(this.channel);
        message.setDatetime(this.dateFormatter.format(new Date()));
        message.getContext().put("host", this.host);
        for (Map.Entry contextItem : event.getContextData().toMap().entrySet()) {
            message.getContext().put((String)contextItem.getKey(), (String)contextItem.getValue());
        }
        if (this.layout != null) {
            message.setMessage(new String(this.layout.toByteArray(event)));
        } else {
            message.setMessage(event.getMessage().getFormattedMessage());
        }
        return message;
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<SmartlingExternalAppender> {
        @PluginBuilderAttribute
        private String logServiceUrl = "https://api.smartling.com/updates/status";
        @PluginBuilderAttribute
        private String host;
        @PluginBuilderAttribute
        private String proxyHost;
        @PluginBuilderAttribute
        private Integer proxyPort;
        @PluginBuilderAttribute
        private String proxyUser;
        @PluginBuilderAttribute
        private String proxyPassword;
        @PluginBuilderAttribute
        private String channel;
        @PluginBuilderAttribute
        private int queueSize = 100;
        @PluginBuilderAttribute
        private int bufferTimeThreshold = 1000;
        @PluginBuilderAttribute
        private int bufferMaxSize = 50;

        public SmartlingExternalAppender build() {
            return new SmartlingExternalAppender(this.getName(), this.getFilter(), this.logServiceUrl, this.host, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword, this.channel, (Layout<? extends Serializable>)this.getLayout(), this.queueSize, this.bufferTimeThreshold, this.bufferMaxSize);
        }

        public B setLogServiceUrl(String logServiceUrl) {
            this.logServiceUrl = logServiceUrl;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setHost(String host) {
            this.host = host;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setProxyPort(Integer proxyPort) {
            this.proxyPort = proxyPort;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setProxyUser(String proxyUser) {
            this.proxyUser = proxyUser;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setProxyPassword(String proxyPassword) {
            this.proxyPassword = proxyPassword;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setChannel(String channel) {
            this.channel = channel;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setQueueSize(int queueSize) {
            this.queueSize = queueSize;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setBufferTimeThreshold(int bufferTimeThreshold) {
            this.bufferTimeThreshold = bufferTimeThreshold;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setBufferMaxSize(int bufferMaxSize) {
            this.bufferMaxSize = bufferMaxSize;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

