/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.connectors.appenders.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.filter.LevelFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.filter.Filter;
import com.smartling.connectors.appenders.core.BlockingQueueFactory;
import com.smartling.connectors.appenders.core.BufferedAppender;
import com.smartling.connectors.appenders.core.LogClient;
import com.smartling.connectors.appenders.core.LogMessage;
import com.smartling.connectors.appenders.core.ProxyConfiguration;
import com.smartling.connectors.appenders.core.QueueAppender;
import com.smartling.connectors.appenders.core.QueueListener;
import com.smartling.connectors.appenders.core.QueueListenerFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.lang3.StringUtils;

public class ExternalAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final String PROPERTY_SUFFIX_PROXY_HOST = "http.proxyHost";
    private static final String PROPERTY_SUFFIX_PROXY_PORT = "http.proxyPort";
    private static final String PROPERTY_SUFFIX_PROXY_USERNAME = "http.proxyUsername";
    private static final String PROPERTY_SUFFIX_PROXY_PASSWORD = "http.proxyPassword";
    private QueueAppender asyncQueueAppender;
    private BufferedAppender bufferedAppender;
    private String logServiceUrl = "https://api.smartling.com/updates/status";
    private String host;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private String channel;
    private Layout<ILoggingEvent> layout;
    private int queueSize = 100;
    private int bufferTimeThreshold = 1000;
    private int bufferMaxSize = 50;

    public ExternalAppender() {
        LevelFilter levelFilter = new LevelFilter();
        levelFilter.setLevel(Level.DEBUG);
        this.addFilter((Filter)levelFilter);
    }

    public void start() {
        super.start();
        String userAgent = "SmartlingExternalAppender/" + ((Object)((Object)this)).getClass().getPackage().getImplementationVersion();
        LogClient logClient = new LogClient(this.logServiceUrl, userAgent, this.createProxyConfiguration());
        this.bufferedAppender = new BufferedAppender(logClient, this.bufferMaxSize);
        BlockingQueueFactory blockingQueueFactory = new BlockingQueueFactory(){

            @Override
            public BlockingQueue<LogMessage> create() {
                return new ArrayBlockingQueue<LogMessage>(ExternalAppender.this.queueSize);
            }
        };
        QueueListenerFactory queueListenerFactory = new QueueListenerFactory(){

            @Override
            public QueueListener create(QueueAppender queueAppender, BlockingQueue<LogMessage> queue) {
                return new QueueListener(queueAppender, queue, ExternalAppender.this.bufferedAppender, ExternalAppender.this.bufferTimeThreshold);
            }
        };
        this.asyncQueueAppender = new QueueAppender(blockingQueueFactory, queueListenerFactory);
        if (this.layout != null) {
            if (this.layout.getContext() == null) {
                this.layout.setContext(this.getContext());
            }
            if (!this.layout.isStarted()) {
                this.layout.start();
            }
        }
        if (StringUtils.isEmpty((CharSequence)this.host)) {
            this.host = this.detectHostName();
        }
    }

    private String detectHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "UNKNOWN_LOCALHOST";
        }
    }

    public void stop() {
        try {
            super.stop();
        }
        finally {
            if (this.asyncQueueAppender != null) {
                this.asyncQueueAppender.close();
            }
            if (this.bufferedAppender != null) {
                this.bufferedAppender.close();
            }
            if (this.layout != null) {
                this.layout.stop();
            }
        }
    }

    protected void append(ILoggingEvent event) {
        if (this.asyncQueueAppender != null) {
            LogMessage logMessage = this.createLogMessage(event);
            this.asyncQueueAppender.log(logMessage);
        }
    }

    private LogMessage createLogMessage(ILoggingEvent event) {
        LogMessage message = new LogMessage();
        message.setLevelName(event.getLevel().levelStr);
        message.setChannel(this.channel);
        message.setDatetime(this.dateFormatter.format(new Date()));
        message.getContext().put("host", this.host);
        for (Map.Entry contextItem : event.getMDCPropertyMap().entrySet()) {
            message.getContext().put((String)contextItem.getKey(), (String)contextItem.getValue());
        }
        if (this.layout != null) {
            message.setMessage(this.layout.doLayout((Object)event));
        } else {
            message.setMessage(event.getFormattedMessage());
        }
        return message;
    }

    private ProxyConfiguration createProxyConfiguration() {
        if (StringUtils.isNotEmpty((CharSequence)this.proxyHost) && this.proxyPort != null) {
            ProxyConfiguration proxyConfiguration = new ProxyConfiguration();
            proxyConfiguration.setHost(this.proxyHost);
            proxyConfiguration.setPort(this.proxyPort);
            proxyConfiguration.setUsername(this.proxyUser);
            proxyConfiguration.setPassword(this.proxyPassword);
            return proxyConfiguration;
        }
        if (StringUtils.isNotBlank((CharSequence)System.getProperty(PROPERTY_SUFFIX_PROXY_HOST)) && StringUtils.isNotBlank((CharSequence)System.getProperty(PROPERTY_SUFFIX_PROXY_PORT))) {
            ProxyConfiguration proxyConfiguration = new ProxyConfiguration();
            proxyConfiguration.setHost(System.getProperty(PROPERTY_SUFFIX_PROXY_HOST));
            proxyConfiguration.setPort(Integer.valueOf(System.getProperty(PROPERTY_SUFFIX_PROXY_PORT)));
            proxyConfiguration.setUsername(System.getProperty(PROPERTY_SUFFIX_PROXY_USERNAME));
            proxyConfiguration.setPassword(System.getProperty(PROPERTY_SUFFIX_PROXY_PASSWORD));
            return proxyConfiguration;
        }
        return null;
    }

    public String getLogServiceUrl() {
        return this.logServiceUrl;
    }

    public void setLogServiceUrl(String logServiceUrl) {
        this.logServiceUrl = logServiceUrl;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public Layout<ILoggingEvent> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    public int getBufferTimeThreshold() {
        return this.bufferTimeThreshold;
    }

    public void setBufferTimeThreshold(int bufferTimeThreshold) {
        this.bufferTimeThreshold = bufferTimeThreshold;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getBufferMaxSize() {
        return this.bufferMaxSize;
    }

    public void setBufferMaxSize(int bufferMaxSize) {
        this.bufferMaxSize = bufferMaxSize;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }
}

