/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn.ssh.apache;

import com.trilead.ssh2.auth.AgentProxy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.tmatesoft.svn.core.auth.ISVNSSHHostVerifier;
import org.tmatesoft.svn.core.internal.io.svn.ssh.SshSession;
import org.tmatesoft.svn.core.internal.io.svn.ssh.SshSessionPool;
import org.tmatesoft.svn.core.internal.io.svn.ssh.apache.ApacheSshSession;
import org.tmatesoft.svn.core.internal.io.svn.ssh.apache.SshHost;
import org.tmatesoft.svn.core.internal.io.svn.ssh.apache.SshHostDisposedException;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class ApacheSshSessionPool
implements SshSessionPool {
    private static final long PURGE_INTERVAL = 10000L;
    private final Map<String, SshHost> myPool = new HashMap<String, SshHost>();

    public ApacheSshSessionPool() {
        Timer myTimer = new Timer(true);
        myTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = ApacheSshSessionPool.this.myPool;
                synchronized (map) {
                    ArrayList hosts = new ArrayList(ApacheSshSessionPool.this.myPool.values());
                    for (SshHost host : hosts) {
                        if (host.purge()) {
                            ApacheSshSessionPool.this.myPool.remove(host.getKey());
                        }
                        SVNDebugLog.getDefaultLog().logFinest(SVNLogType.NETWORK, "SSH pool, purged: " + host);
                    }
                }
            }
        }, 10000L, 10000L);
    }

    @Override
    public SshSession openSession(String host, int port, String userName, char[] privateKey, char[] passphrase, char[] password, AgentProxy agentProxy, ISVNSSHHostVerifier verifier, int connectTimeout, int readTimeout) throws IOException {
        return this.openSession(host, port, userName, privateKey, passphrase, password, verifier, connectTimeout, readTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Map<String, SshHost> map = this.myPool;
        synchronized (map) {
            ArrayList<SshHost> hosts = new ArrayList<SshHost>(this.myPool.values());
            for (SshHost host : hosts) {
                try {
                    host.lock();
                    host.setDisposed(true);
                    this.myPool.remove(host.getKey());
                }
                finally {
                    host.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApacheSshSession openSession(String host, int port, String userName, char[] privateKey, char[] passphrase, char[] password, ISVNSSHHostVerifier verifier, int connectTimeout, int readTimeout) throws IOException {
        SshHost newHost = new SshHost(host, port);
        newHost.setCredentials(userName, privateKey, passphrase, password);
        newHost.setConnectionTimeout(connectTimeout);
        newHost.setHostVerifier(verifier);
        newHost.setReadTimeout(readTimeout);
        String hostKey = newHost.getKey();
        while (true) {
            SshHost sshHost;
            Map<String, SshHost> map = this.myPool;
            synchronized (map) {
                sshHost = this.myPool.get(hostKey);
                if (sshHost == null) {
                    sshHost = newHost;
                    this.myPool.put(hostKey, newHost);
                }
            }
            try {
                return sshHost.openSession();
            }
            catch (SshHostDisposedException e) {
                Map<String, SshHost> map2 = this.myPool;
                synchronized (map2) {
                    this.myPool.remove(hostKey);
                }
            }
        }
    }
}

